% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{c_net_plot}
\alias{c_net_plot}
\title{Plot a metanet}
\usage{
c_net_plot(
  go,
  coors = NULL,
  ...,
  labels_num = 5,
  vertex_size_range = NULL,
  edge_width_range = NULL,
  plot_module = FALSE,
  mark_module = FALSE,
  mark_color = NULL,
  mark_alpha = 0.3,
  module_label = FALSE,
  module_label_cex = 2,
  module_label_color = "black",
  module_label_just = c(0.5, 0.5),
  legend = TRUE,
  legend_number = FALSE,
  legend_cex = 1,
  legend_position = c(left_leg_x = -2, left_leg_y = 1, right_leg_x = 1.2, right_leg_y =
    1),
  group_legend_title = NULL,
  group_legend_order = NULL,
  color_legend = TRUE,
  color_legend_order = NULL,
  size_legend = FALSE,
  size_legend_title = "Node Size",
  edge_legend = TRUE,
  edge_legend_title = "Edge type",
  edge_legend_order = NULL,
  width_legend = FALSE,
  width_legend_title = "Edge width",
  lty_legend = FALSE,
  lty_legend_title = "Edge class",
  lty_legend_order = NULL,
  seed = 1234
)
}
\arguments{
\item{go}{an igraph or metanet object}

\item{coors}{the coordinates you saved}

\item{...}{additional parameters for \code{\link[igraph]{igraph.plotting}}}

\item{labels_num}{show how many labels,>1 indicates number, <1 indicates fraction, "all" indicates all, default:5}

\item{vertex_size_range}{the vertex size range, e.g. c(1,10)}

\item{edge_width_range}{the edge width range, e.g. c(1,10)}

\item{plot_module}{logical, plot module?}

\item{mark_module}{logical, mark the modules?}

\item{mark_color}{mark colors}

\item{mark_alpha}{mark fill alpha, default 0.3}

\item{module_label}{module_label}

\item{module_label_cex}{module_label_cex}

\item{module_label_color}{module_label_color}

\item{module_label_just}{module_label_just}

\item{legend}{all legends}

\item{legend_number}{legend with numbers}

\item{legend_cex}{character expansion factor relative to current par("cex"), default: 1}

\item{legend_position}{legend_position, default: c(left_leg_x=-1.9,left_leg_y=1,right_leg_x=1.2,right_leg_y=1)}

\item{group_legend_title}{group_legend_title, length must same to the numbers of v_group}

\item{group_legend_order}{group_legend_order vector}

\item{color_legend}{logical}

\item{color_legend_order}{color_legend_order vector}

\item{size_legend}{logical}

\item{size_legend_title}{size_legend_title}

\item{edge_legend}{logical}

\item{edge_legend_title}{edge_legend_title}

\item{edge_legend_order}{edge_legend_order vector, e.g. c("positive","negative")}

\item{width_legend}{logical}

\item{width_legend_title}{width_legend_title}

\item{lty_legend}{logical}

\item{lty_legend_title}{lty_legend_title}

\item{lty_legend_order}{lty_legend_order}

\item{seed}{random seed, default:1234, make sure each plot is the same.}
}
\value{
a network plot
}
\description{
Plot a metanet
}
\examples{
data("c_net")
c_net_plot(co_net)
c_net_plot(co_net2)
c_net_plot(multi1)
}
\seealso{
Other plot: 
\code{\link{as.ggig}()},
\code{\link{input_gephi}()},
\code{\link{netD3plot}()},
\code{\link{olympic_rings_net}()},
\code{\link{plot.ggig}()},
\code{\link{twocol_edgelist}()},
\code{\link{venn_net}()}
}
\concept{plot}
