% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{c_net_stability}
\alias{c_net_stability}
\alias{robust_test}
\alias{vulnerability}
\alias{robustness}
\title{Evaluate the stability of a network}
\usage{
c_net_stability(
  go_ls,
  mode = "robust_test",
  partial = 0.5,
  step = 10,
  reps = 9,
  threads = 1,
  verbose = TRUE,
  keystone = FALSE
)

robust_test(
  go_ls,
  partial = 0.5,
  step = 10,
  reps = 9,
  threads = 1,
  verbose = TRUE
)

vulnerability(go_ls, threads = 1, verbose = TRUE)

robustness(go_ls, keystone = FALSE, reps = 9, threads = 1, verbose = TRUE)
}
\arguments{
\item{go_ls}{an igraph object or igraph list.}

\item{mode}{"robust_test", "vulnerability", "robustness"}

\item{partial}{how much percent vertexes be removed in total (default: 0.5, only for robust_test)}

\item{step}{how many nodes be removed each time? (default: 10, only for robust_test)}

\item{reps}{simulation number (default: 9)}

\item{threads}{threads}

\item{verbose}{verbose}

\item{keystone}{remove 70\%\% keystones instead of remove 50\%\% nodes (default: False, only for robustness)}
}
\value{
a data.frame

data.frame (robustness class)

a vector
}
\description{
\deqn{Vi=\frac{E-Ei}{E}}
E is the global efficiency and Ei is the global efficiency after the removal of the node i and its entire links.
}
\examples{
\donttest{
data("c_net")
if (requireNamespace("ggpmisc")) {
  c_net_stability(co_net, mode = "robust_test", step = 20, reps = 9) -> robust_res
  plot(robust_res, index = "Average_degree", mode = 2)
}

c_net_stability(co_net, mode = "vulnerability") -> vulnerability_res
plot(vulnerability_res)

robustness(co_net) -> robustness_res
plot(robustness_res)

module_detect(co_net) -> co_net_modu
zp_analyse(co_net_modu, mode = 2) -> co_net_modu

c_net_stability(co_net_modu, mode = "robustness", keystone = TRUE) -> robustness_res
plot(robustness_res)
}
}
