\name{ScoresMS1}
\alias{ScoresMS1}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Statistical Analysis for a pair of peaks annotated for a particular metabolite.
}
\description{
Isotopic distribution or multiple adducts of a particular compound can be evaluated by the ScoresMS1.R function that searches the output generated by the FullMS.R function for compounds annotated with multiple adducts or isotopes, calculating the isotope peak intensity ratio between monoisotopic or first isotopologue and the next one. Function calculates PPC based on intensity for both peaks at each scan forming EICs.
}
\usage{
ScoresMS1(fullmspos,fullmsposb,ID1,ID2)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{fullmspos}{
   Results achieved by FullMS.R function for a particular adduct.
}
  \item{fullmsposb}{
 Results achieved by FullMS.R function for a particular adduct}
  \item{ID1}{
  PeakID of the peak corresponding to fileA.
  }
  \item{ID2}{
  PeakID of the peak corresponding to fileB.
  }

}



\value{
  \item{Score}{Peak-to-peak Pearson correlation coefficient for a pair of EIC peaks.}
  \item{IntensityRatio}{Isotope peak intensity ratio between monoisotopic or first isotopologue and the next one.}
  \item{AssymetriRatio}{Score for the chromatogram peak shape based on assymmetry factor.}
  \item{name}{Metabolite name.}
}


\author{Manuel D Peris Diaz}
\references{
1. R-MetaboList: a flexible tool for metabolite extraction from high-resolution data-independent acquisition mass spectrometry analysis. Metabolites. Soon

2. A Survey of Orbitrap All Ion Fragmentation Analysis Assessed by an R MetaboList Package to Study Small-Molecule Metabolites. Chromatographia. 2018, 81, 981-994.
}
\examples{
library(MetaboList)
#Reading the file.mzXML
# file<-fullMS.mzXML

#Reading the database.csv file:
# database<- read.csv("C:/FullMS1.csv")

#Processing peak-picking and annotation with default parameters
# FullMS_results<-FullMS(file,database, ion_mode = "negative",)


#ScoresMS1<-ScoresMS1(FullMS_results,FullMS_results,ID2=149,ID1=148)


}
