% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassificationCV.R
\name{ClassificationCV}
\alias{ClassificationCV}
\title{ClassificationCV.}
\usage{
ClassificationCV(d = NULL, g = NULL, n = 1, k = 1, rand = F,
  method = c("svm", "C50", "rpart")[1], svm.kernel = "linear",
  svm.type = "C-classification", tree.method = "class",
  rpart.control = list())
}
\arguments{
\item{d}{Data matrix or data.frame with named rows (samples) and columns (traits).}

\item{g}{Group-vector, factor.}

\item{n}{Replicates of classifications.}

\item{k}{Number of folds per replicate.}

\item{rand}{Randomize Group-vector (and apply according n and k to this randomization).}

\item{method}{Currently \code{svm} and decison tree methods \code{C50} and \code{rpart} are supported.}

\item{svm.kernel}{Pass through options for svm method.}

\item{svm.type}{Pass through options for svm method.}

\item{tree.method}{Pass through options for tree method.}

\item{rpart.control}{Forwarded to rpart.}
}
\value{
Nothing.
}
\description{
\code{ClassificationCV} will perform a classification using SVM's and/or Decision Trees including cross validation on a data set according to a provided grouping vector.
}
\details{
not yet
}
\examples{
# classify american and european parental lines
utils::data(raw, package = "MetabolomicsBasics")
utils::data(sam, package = "MetabolomicsBasics")
gr <- sam$Origin

# establish a basic rpart model and render a fancy plot including the accuracy
class_res <- ClassificationCV(d=raw, g=gr, method="rpart")
rattle::fancyRpartPlot(class_res, main="Optimal rpart decision tree")
acc_opt <- caret::confusionMatrix(predict(class_res, newdata=data.frame(raw), type="class"), gr)
mtext(paste("Accuracy =", round(acc_opt[["overall"]]["Accuracy"],2)), adj = 0)

# now repeat the analysis in a robust fashion (10-fold cross validation in 100 permutations)
\donttest{
class_res <- ClassificationCV(g=gr, d=raw, n=100, k=10, method="rpart")
acc_crossval <- sapply(class_res, function(x) {
 round(x$ConfusionMatrix[["overall"]]["Accuracy"],2)
})
hist(acc_crossval, sub=paste("Accuracy optimal =",round(acc_optacc_opt[["overall"]]["Accuracy"],2)))
}

# check the examples in \\code{\\link{ClassificationWrapper}} for automatic multifold analysis

}
