% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde_sampling.R
\name{sample_spde}
\alias{sample_spde}
\title{Samples a Whittle-Matérn field on a metric graph}
\usage{
sample_spde(
  kappa,
  tau,
  range,
  sigma,
  sigma_e = 0,
  alpha = 1,
  graph,
  PtE = NULL,
  type = "manual",
  posterior = FALSE,
  nsim = 1,
  method = c("conditional", "Q"),
  BC = 1
)
}
\arguments{
\item{kappa}{Range parameter.}

\item{tau}{Precision parameter.}

\item{range}{Practical correlation range parameter.}

\item{sigma}{Marginal standard deviation parameter.}

\item{sigma_e}{Standard deviation of the measurement noise.}

\item{alpha}{Smoothness parameter.}

\item{graph}{A \code{metric_graph} object.}

\item{PtE}{Matrix with locations (edge, normalized distance on edge) where
the samples should be generated.}

\item{type}{If "manual" is set, then sampling is done at the locations
specified in \code{PtE}. Set to "mesh" for simulation at mesh nodes, and to "obs"
for simulation at observation locations.}

\item{posterior}{Sample conditionally on the observations?}

\item{nsim}{Number of samples to be generated.}

\item{method}{Which method to use for the sampling? The options are
"conditional" and "Q". Here, "Q" is more stable but takes longer.}

\item{BC}{Boundary conditions for degree 1 vertices. BC = 0 gives Neumann
boundary conditions and BC = 1 gives stationary boundary conditions.}
}
\value{
Matrix or vector with the samples.
}
\description{
Obtains samples of a Whittle-Matérn field on a metric graph.
}
\details{
Samples a Gaussian Whittle-Matérn field on a metric graph, either
from the prior or conditionally on observations
\deqn{y_i = u(t_i) + \sigma_e e_i}{y_i = u(t_i) + \sigma_e e_i}
on the graph,  where \eqn{e_i} are independent standard Gaussian variables.
The parameters for the field can either be specified in terms of tau and kappa
or practical correlation range and marginal standard deviation.
}
