% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krona.R
\name{krona}
\alias{krona}
\title{Make Krona files using \href{https://github.com/marbl/Krona/wiki}{KronaTools}.}
\usage{
krona(
  physeq,
  file = "krona.html",
  nb_seq = TRUE,
  ranks = "All",
  add_unassigned_rank = 0,
  name = NULL
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{file}{(required) the location of the html file to save}

\item{nb_seq}{(logical) If true, Krona set the distribution
of sequences in the taxonomy. If False, Krona set the distribution of ASVs
in the taxonomy.}

\item{ranks}{Number of the taxonomic ranks to plot
(num of the column in \code{tax_table} slot of your \code{physeq} object).
Default setting plot all the ranks (argument 'All').}

\item{add_unassigned_rank}{(int) Add unassigned for rank
inferior to 'add_unassigned_rank' when necessary.}

\item{name}{A name for intermediary files, Useful to name
your krona result files before merging using \code{\link[=merge_krona]{merge_krona()}}}
}
\value{
A html file
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Need the installation of kronatools on the computer (\href{https://github.com/marbl/Krona/wiki/Installing}{installation instruction}).
}
\details{
This function is mainly a wrapper of the work of others.
Please cite \href{https://github.com/marbl/Krona}{Krona} if
you use this function.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows" && MiscMetabar::is_krona_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("GlobalPatterns", package = "phyloseq")
GA <- subset_taxa(GlobalPatterns, Phylum == "Acidobacteria")
\dontrun{
krona(GA, "Number.of.sequences.html")
krona(GA, "Number.of.ASVs.html", nb_seq = FALSE)
merge_krona(c("Number.of.sequences.html", "Number.of.ASVs.html"))
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{merge_krona}}
}
\author{
Adrien Taudière
}
