% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logMoments.R
\name{logMomentEstimator}
\alias{logMomentEstimator}
\title{Log-Moments Estimator for the Mittag-Leffler Distribution.}
\usage{
logMomentEstimator(x, alpha = 0.05)
}
\arguments{
\item{x}{A vector of non-negative data.}

\item{alpha}{Confidence intervals are calculated at level 1 - alpha.}
}
\value{
A named vector with entries (nu, delta, nuLo, nuHi, deltaLo, deltaHi)
where nu is the tail parameter and delta the scale parameter of the 
Mittag-Leffler distribution, with confidence intervals 
(nuLo, nuHi) resp. (deltaLo, deltaHi).
}
\description{
Tail and scale parameter of the Mittag-Leffler distribution are estimated
by matching with the first two empirical log-moments
(see Cahoy et al., \url{http://doi.org/10.1016/j.jspi.2010.04.016}).
}
\examples{
logMomentEstimator(rml(n = 1000, scale = 0.03, tail = 0.84), alpha=0.95)
}
\references{
Cahoy, D. O., Uchaikin, V. V., & Woyczynski Wojbor, W. A. (2010).  
Parameter estimation for fractional Poisson processes.  
Journal of Statistical Planning and Inference, 140(11), 3106–3120. 
\url{http://doi.org/10.1016/j.jspi.2010.04.016}

Cahoy, D. O. (2013). 
Estimation of Mittag-Leffler Parameters. 
Communications in Statistics - Simulation and Computation, 42(2), 303–315. 
\url{http://doi.org/10.1080/03610918.2011.640094}
}
