% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterPredict.R
\name{clusterPredict}
\alias{clusterPredict}
\title{Create an instance of [\code{\linkS4class{ClusterPredict}}] class}
\usage{
clusterPredict(data, model, algo = clusterAlgoPredict(), nbCore = 1)
}
\arguments{
\item{data}{dataframe or matrix containing the data. Rows correspond to observations
and columns correspond to variables. If the data set contains NA values, they
will be estimated during the predicting process.}

\item{model}{(estimated) clustering model to use, i.e. an instance of
\code{\linkS4class{ClusterCategorical}}, \code{\linkS4class{ClusterDiagGaussian}},..
produced by \code{\link{clusterCategorical}}, \code{\link{clusterDiagGaussian}},...
\code{\link{learnCategorical}}, \code{\link{learnDiagGaussian}}, etc.
functions.}

\item{algo}{an instance of \code{\linkS4class{ClusterAlgoPredict}} S4 class. Will not
be used if there is no missing values.}

\item{nbCore}{integer defining the number of processors to use (default is 1, 0 for all).}
}
\value{
An instance of [\code{\linkS4class{ClusterPredict}}] with predicted
values
}
\description{
This function predicts the best cluster each sample in data belongs to.
}
\examples{
## A quantitative example with the famous iris data set
data(iris)
## get quantitatives 
x = as.matrix(iris[1:4])
## sample train and test data sets
indexes <- sample(1:nrow(x), nrow(x)/2)
train <- x[ indexes,]
test  <- x[-indexes,]
## estimate model (using fast strategy, results may be misleading)
model1 <- clusterDiagGaussian( data =train, nbCluster=2:3
                             , models=c( "gaussian_p_sjk")
                             )
## get summary
summary(model1)
## compute prediction and compare
model2 <- clusterPredict(test, model1)
show(model2)
as.integer(iris$Species[-indexes])

}
\author{
Serge Iovleff
}
