% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixsiar_gui.R
\name{mixsiar_gui}
\alias{mixsiar_gui}
\title{Run the GUI version of MixSIAR}
\usage{
mixsiar_gui()
}
\value{
\code{mixsiar_gui} itself returns nothing, but using the GUI creates
R objects that you can access from the console:
 \itemize{
   \item \code{mixsiar$mix}: mixture data, output of \code{\link{load_mix_data}})
   \item \code{mixsiar$source}: source data, output of \code{\link{load_source_data}})
   \item \code{mixsiar$discr}: discrimination (TDF) data, output of \code{\link{load_discr_data}}
   \item \code{mixsiar$jags.1}: rjags model object with MCMC chains, output of \code{\link{run_model}}
 }
}
\description{
\code{mixsiar_gui} creates the GUI version of MixSIAR.
}
\details{
\emph{Before running this function}, a new user will need to install JAGS
and GTK+. See Section 2 of the manual for install instructions:
\url{https://github.com/brianstock/MixSIAR/blob/master/inst/mixsiar_manual_3.1_small.pdf}

\code{mixsiar_gui} calls most of the other \code{MixSIAR} functions:
 \itemize{
   \item \code{\link{load_mix_data}}
   \item \code{\link{load_source_data}}
   \item \code{\link{load_discr_data}}
   \item \code{\link{plot_data}}
   \item \code{\link{plot_prior}}
   \item \code{\link{write_JAGS_model}}
   \item \code{\link{run_model}}
   \item \code{\link{output_JAGS}}
 }
}
\examples{
mixsiar_gui()

}
\seealso{
\code{\link{load_mix_data}} loads the mixture data file,

\code{\link{load_source_data}} loads the source data file,

\code{\link{load_discr_data}} loads the TDF data file,

\code{\link{plot_data}} creates an isospace plot,

\code{\link{plot_prior}} plots your prior and the uninformative prior,

\code{\link{write_JAGS_model}} creates a JAGS model file (.txt),

\code{\link{run_model}} sets up JAGS objects and calls JAGS to run
         the model,

\code{\link{output_JAGS}} processes the JAGS output (prints/saves
         diagnostics, summary statistics, and plots)
}

