% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb_opt.R
\name{xgb_opt}
\alias{xgb_opt}
\title{Bayesian Optimization for XGboost}
\usage{
xgb_opt(train_data, train_label, test_data, test_label, objectfun, evalmetric,
  eta_range = c(0.1, 1L), max_depth_range = c(4L, 6L),
  nrounds_range = c(70, 160L), subsample_range = c(0.1, 1L),
  bytree_range = c(0.4, 1L), init_points = 4, n_iter = 10, acq = "ei",
  kappa = 2.576, eps = 0, optkernel = list(type = "exponential", power =
  2), classes = NULL)
}
\arguments{
\item{train_data}{A data frame for training of xgboost}

\item{train_label}{The column of class to classify in the training data}

\item{test_data}{A data frame for training of xgboost}

\item{test_label}{The column of class to classify in the test data}

\item{objectfun}{Specify the learning task and the corresponding learning objective
\itemize{
    \item \code{reg:linear} linear regression (Default).
    \item \code{reg:logistic} logistic regression.
    \item \code{binary:logistic} logistic regression for binary classification. Output probability.
    \item \code{binary:logitraw} logistic regression for binary classification, output score before logistic transformation.
    \item \code{multi:softmax} set xgboost to do multiclass classification using the softmax objective. Class is represented by a number and should be from 0 to \code{num_class - 1}.
    \item \code{multi:softprob} same as softmax, but prediction outputs a vector of ndata * nclass elements, which can be further reshaped to ndata, nclass matrix. The result contains predicted probabilities of each data point belonging to each class.
    \item \code{rank:pairwise} set xgboost to do ranking task by minimizing the pairwise loss.
  }}

\item{evalmetric}{evaluation metrics for validation data. Users can pass a self-defined function to it. Default: metric will be assigned according to objective(rmse for regression, and error for classification, mean average precision for ranking).
\itemize{
  \item \code{error} binary classification error rate
  \item \code{rmse} Rooted mean square error
  \item \code{logloss} negative log-likelihood function
  \item \code{auc} Area under curve
  \item \code{merror} Exact matching error, used to evaluate multi-class classification
}}

\item{eta_range}{The range of eta}

\item{max_depth_range}{The range of max_depth}

\item{nrounds_range}{The range of nrounds}

\item{subsample_range}{The range of subsample rate}

\item{bytree_range}{The range of colsample_bytree rate}

\item{init_points}{Number of randomly chosen points to sample the
target function before Bayesian Optimization fitting the Gaussian Process.}

\item{n_iter}{Total number of times the Bayesian Optimization is to repeated.}

\item{acq}{Acquisition function type to be used. Can be "ucb", "ei" or "poi".
\itemize{
  \item \code{ucb} GP Upper Confidence Bound
  \item \code{ei} Expected Improvement
  \item \code{poi} Probability of Improvement
}}

\item{kappa}{tunable parameter kappa of GP Upper Confidence Bound, to balance exploitation against exploration,
increasing kappa will make the optimized hyperparameters pursuing exploration.}

\item{eps}{tunable parameter epsilon of Expected Improvement and Probability of Improvement, to balance exploitation against exploration,
increasing epsilon will make the optimized hyperparameters are more spread out across the whole range.}

\item{optkernel}{Kernel (aka correlation function) for the underlying Gaussian Process. This parameter should be a list
that specifies the type of correlation function along with the smoothness parameter. Popular choices are square exponential (default) or matern 5/2}

\item{classes}{set the number of classes. To use only with multiclass objectives.}
}
\value{
The test accuracy and a list of Bayesian Optimization result is returned:
\itemize{
  \item \code{Best_Par} a named vector of the best hyperparameter set found
  \item \code{Best_Value} the value of metrics achieved by the best hyperparameter set
  \item \code{History} a \code{data.table} of the bayesian optimization history
  \item \code{Pred} a \code{data.table} with validation/cross-validation prediction for each round of bayesian optimization history
}
}
\description{
This function estimates parameters for xgboost based on bayesian optimization.
}
\examples{
\dontrun{
library(MlBayesOpt)

set.seed(71)
res0 <- xgb_opt(train_data = fashion_train,
                train_label = y,
                test_data = fashion_test,
                test_label = y,
                objectfun = "multi:softmax",
                evalmetric = "merror",
                classes = 10,
                init_points = 3,
                n_iter = 1)
}

}
