% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/motbf.R
\name{Subclass-MoTBF}
\alias{Subclass-MoTBF}
\alias{is.mop}
\alias{is.mte}
\alias{subclass}
\title{Subclass \code{"motbf"} Functions}
\usage{
is.mte(fx)

is.mop(fx)

subclass(fx)
}
\arguments{
\item{fx}{A function of the class \code{"motbf"}.}
}
\value{
\code{is.mte} and \code{is.mop} return a logical value, \code{TRUE} if it is an \code{"motbf"} object of the subclass
\code{"mte"} or \code{"mop"}, respectly; or \code{FALSE} otherwise.
\code{subclass} returns a \code{"character"} string, \code{"mte"} or \code{"mop"}.
}
\description{
Collection of functions for detecting the subclass of an \code{"motbf"}
object. It can be \code{"mop"} or \code{"mte"}.
}
\examples{
## MOP Function
X <- rnorm(1000)
P <- univMoTBF(X, POTENTIAL_TYPE="MOP")
is.mop(P)
subclass(P)

## MTE Function
X <- rchisq(1000, df=4)
P <- univMoTBF(X, POTENTIAL_TYPE="MTE")
is.mte(P)
subclass(P)
}
\seealso{
\link{univMoTBF}
}

