% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mop.R
\name{coef.mop}
\alias{coef.mop}
\alias{coeffMOP}
\alias{coeffPol}
\title{Extract MOP Coefficients}
\usage{
coeffMOP(fx)

coeffPol(fx)
}
\arguments{
\item{fx}{An \code{"motbf"} function of subclass \code{'mop'}.}
}
\value{
An array with the parameters of the function.
}
\description{
It extracts the parameters of the learned mixtures of polynomial models.
}
\details{
\code{coeffMOP()} return the coefficients of the terms in the function.

\code{coeffPol()} returns the coefficients of the potential of the polynomial basis in the function.
}
\examples{
## 1. EXAMPLE
data <- rchisq(1000, df=5)
fx1 <- univMoTBF(data, POTENTIAL_TYPE = "MOP")
hist(data, prob=TRUE, main="")
plot(fx1, xlim=range(data), col="red", add=TRUE)
coeffMOP(fx1) ## coef(fx1)
coeffPol(fx1)

## 2. EXAMPLE
data <- rexp(1000, rate=1/2)
fx2 <- univMoTBF(data, POTENTIAL_TYPE = "MOP")
hist(data, prob=TRUE, main="")
plot(fx2, xlim=range(data), col="red", add=TRUE)
coeffMOP(fx2) ## coef(fx2)
coeffPol(fx2)
}
\seealso{
\link{coef.motbf} and \link{univMoTBF}
}

