% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{findConditional}
\alias{findConditional}
\title{Find Fitted Conditional MoTBFs}
\usage{
findConditional(node, bn, evi = NULL)
}
\arguments{
\item{node}{A \code{character} string, representing the tardet variable.}

\item{bn}{A list of lists obtained from \link{MoTBFs_Learning}, containing the conditional functions.}

\item{evi}{A \code{data.frame} of dimension '1xn' that contains the values of the 'n' parents of the target node. 
This argument can be \code{NULL} if \code{"node"} is a root node.}
}
\value{
A list containing the conditional distribution of the target variable.
}
\description{
This function returns the conditional probability function of a node given an MoTBF-bayesian network and the value of its parents.
}
\examples{

## Dataset
  data("ecoli", package = "MoTBFs")
  data <- ecoli[,-c(1,9)]

## Get directed acyclic graph
  dag <- LearningHC(data)
  
## Learn bayesian network
  bn <- MoTBFs_Learning(dag, data = data, numIntervals = 4, POTENTIAL_TYPE = "MTE")
  
## Specify the evidence set and node of interest
  evi <- data.frame(lip = "0.48", alm1 = 0.55, gvh = 1, stringsAsFactors=FALSE)
  node = "alm2"
  
## Get the conditional distribution
  findConditional(node, bn, evi)

}
