% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{armadillo.subset}
\alias{armadillo.subset}
\title{Describes data available to subset and makes subset}
\usage{
armadillo.subset(
  input_source = NULL,
  subset_def = NULL,
  source_project = NULL,
  source_folder = NULL,
  source_table = NULL,
  target_project = NULL,
  target_folder = NULL,
  target_table = NULL,
  target_vars = NULL,
  new_project = NULL,
  dry_run = NULL
)
}
\arguments{
\item{input_source}{Character specifying how information about the target view is provided: choose
'subset_def' if providing a subset definition object, or 'arguments' if providing information directly.}

\item{subset_def}{R object containing subset definition created by
\code{armadillo.subset_definition()}. Compulsory if input_source = 'subset_def'}

\item{source_project}{project from which to subset data}

\item{source_folder}{folder from which to subset data. Compulsory if input_source = 'arguments'.}

\item{source_table}{table from which to subset data. Compulsory if input_source = 'arguments'.}

\item{target_project}{project to upload subset to. Will be created if it doesn't exist.}

\item{target_folder}{folder to upload subset to. Will be created if it doesn't exist.
Compulsory if input_source = 'arguments'.}

\item{target_table}{table to upload subset to. Compulsory if input_source = 'arguments'.}

\item{target_vars}{variables from `source_table` to include in the view.
Compulsory if input_source = 'arguments'.}

\item{new_project}{Deprecated: use \code{target_project} instead}

\item{dry_run}{Defunct: previously enabgled dry-run to check which variables are missing}
}
\value{
missing variables provided in the subset definition
}
\description{
This automates the process of:
\enumerate{
 \item Checking what data is available to create subsets
 \item Make the subset
}
}
\examples{
\dontrun{
armadillo.subset(
  source_project = "gecko",
  target_project = "study1",
  subset_def = local_subset
)
}

}
