% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_bookstein}
\alias{coo_bookstein}
\title{Register Bookstein's coordinates}
\usage{
coo_bookstein(coo, ldk1, ldk2)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or a \code{list}, or any \link{Coo} object.}

\item{ldk1}{\code{numeric} the id of the first point of the new baseline (the first, by default)}

\item{ldk2}{\code{numeric} the id of the second point of the new baseline (the last, by default)}
}
\value{
a \code{matrix} of (x; y) coordinates, or a \link{Coo} object.
}
\description{
Registers a new baseline for the shape, with the \code{ldk1}-th
and \code{ldk2}-th points being set on \eqn{(x= -0.5; y=0)} and \eqn{(x= 0.5; y=0)}, respectively.
}
\details{
For \link{Out}, it tries to do it using \code{$ldk} slot. Also the case for \link{Opn}, but if
no landmark is defined, it will do it on the first and the last point of the shape.

For \code{Out} and \code{Opn} defines the first landmark as the first point of the
new shapes with \link{coo_slide}.
}
\examples{
stack(hearts)
stack(coo_bookstein(hearts, 2, 4))
h <- hearts[1]
coo_plot(h)
coo_plot(coo_bookstein(h, 20, 57), border='red')
}
\seealso{
Other baselining functions: \code{\link{coo_baseline}}

Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_calliper}},
  \code{\link{coo_centdist}}, \code{\link{coo_center}},
  \code{\link{coo_centpos}}, \code{\link{coo_centsize}},
  \code{\link{coo_close}}, \code{\link{coo_down}},
  \code{\link{coo_dxy}}, \code{\link{coo_extract}},
  \code{\link{coo_flipx}}, \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}}, \code{\link{coo_nb}},
  \code{\link{coo_perimcum}}, \code{\link{coo_perimpts}},
  \code{\link{coo_perim}}, \code{\link{coo_rev}},
  \code{\link{coo_right}}, \code{\link{coo_rotatecenter}},
  \code{\link{coo_rotate}}, \code{\link{coo_samplerr}},
  \code{\link{coo_sample}}, \code{\link{coo_scalex}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trim}}, \code{\link{coo_up}},
  \code{\link{is_closed}}
}

