% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-def-Out.R
\name{rm_asym}
\alias{rm_asym}
\alias{rm_sym}
\alias{rm_asym.default}
\alias{rm_asym.OutCoe}
\alias{rm_sym}
\alias{rm_sym.default}
\alias{rm_sym.OutCoe}
\title{Removes asymmetric and symmetric variation on OutCoe objects}
\usage{
rm_asym(OutCoe)

\method{rm_asym}{default}(OutCoe)

\method{rm_asym}{OutCoe}(OutCoe)

rm_sym(OutCoe)

\method{rm_sym}{default}(OutCoe)

\method{rm_sym}{OutCoe}(OutCoe)
}
\arguments{
\item{OutCoe}{an OutCoe object}
}
\value{
an OutCoe object
}
\description{
Only for those obtained with \link{efourier}, otherwise a message is returned.
\code{rm_asym} sets all B and C coefficients to 0; \code{rm_sym} sets
all A and D coefficients to 0.
}
\examples{
data(bot)
botf <- efourier(bot, 12)
botSym <- rm_asym(botf)
boxplot(botSym)
botSymp <- PCA(botSym)
plot(botSymp)
plot(botSymp, amp.shp=5)

# Asymmetric only
botAsym <- rm_sym(botf)
boxplot(botAsym)
botAsymp <- PCA(botAsym)
plot(botAsymp)
# strange shapes because the original shape was mainly symmetric and would need its
# symmetric (eg its average) for a proper reconstruction. Should only be used like that:
plot(botAsymp, morpho=FALSE)
}
\references{
Below: the first mention, and two applications.
\itemize{
#' \item Iwata, H., Niikura, S., Matsuura, S., Takano, Y., & Ukai, Y. (1998).
Evaluation of variation of root shape of Japanese radish (Raphanus sativus L.)
based on image analysis using elliptic Fourier descriptors. Euphytica, 102, 143-149.
\item Iwata, H., Nesumi, H., Ninomiya, S., Takano, Y., & Ukai, Y. (2002).
The Evaluation of Genotype x Environment Interactions of Citrus Leaf Morphology
Using Image Analysis and Elliptic Fourier Descriptors. Breeding Science, 52(2),
89-94. doi:10.1270/jsbbs.52.89
\item Yoshioka, Y., Iwata, H., Ohsawa, R., & Ninomiya, S. (2004).
Analysis of petal shape variation of Primula sieboldii by elliptic fourier descriptors
and principal component analysis. Annals of Botany, 94(5), 657-64. doi:10.1093/aob/mch190
}
}
\seealso{
\link{symmetry}.
}
