% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_convexity}
\alias{coo_convexity}
\title{Calculates the convexity of a shape}
\source{
Rosin PL. 2005. Computing global shape measures.
Handbook of Pattern Recognition and Computer Vision. 177-196.
}
\usage{
coo_convexity(coo)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates.}
}
\value{
\code{numeric} for a single shape, \code{list} for a \code{Coo}
}
\description{
Calculated using a ratio of the eigen values (inertia axis)
}
\examples{
coo_convexity(bot[1])
bot \%>\%
    slice(1:3) \%>\% # for speed sake only
    coo_convexity()
}
\seealso{
Other coo_ descriptors: \code{\link{coo_angle_edge1}},
  \code{\link{coo_angle_edges}},
  \code{\link{coo_angle_tangent}}, \code{\link{coo_area}},
  \code{\link{coo_boundingbox}}, \code{\link{coo_chull}},
  \code{\link{coo_circularity}},
  \code{\link{coo_eccentricity}},
  \code{\link{coo_elongation}}, \code{\link{coo_length}},
  \code{\link{coo_lw}}, \code{\link{coo_rectangularity}},
  \code{\link{coo_rectilinearity}},
  \code{\link{coo_solidity}}, \code{\link{coo_width}}
}
