% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_intersect_segment}
\alias{coo_intersect_segment}
\title{Nearest intersection between a shape and a segment}
\usage{
coo_intersect_segment(coo, seg, center = TRUE)
}
\arguments{
\item{coo}{\code{matrix} of \code{(x; y)} coordinates or any \link{Coo} object.}

\item{seg}{a 2x2 \code{matrix} defining the starting and ending points;
or a list or a numeric of length 4.}

\item{center}{\code{logical} whether to center the shape (TRUE by default)}
}
\value{
\code{numeric} the id of the nearest point, a \code{list} for \code{Coo}. See examples.
}
\description{
Take a shape, and an intersecting segment, which point is the nearest
of where the segment intersects with the shape? Most of the time,
centering before makes more sense.
}
\examples{
coo <- bot[1] \%>\% coo_center \%>\% coo_scale
seg <- c(0, 0, 2, 2) # passed as a numeric of length(4)
coo_plot(coo)
segments(seg[1], seg[2], seg[3], seg[4])
coo \%>\% coo_intersect_segment(seg) \%T>\% print \%>\%
# prints on the console and draw it
   coo[., , drop=FALSE] \%>\% points(col="red")

# on Coo
bot \%>\%
    slice(1:3) \%>\% # for the sake of speed
    coo_center \%>\%
    coo_intersect_segment(matrix(c(0, 0, 1000, 1000), ncol=2, byrow=TRUE))
}
\seealso{
Other coo_ intersect: \code{\link{coo_intersect_angle}}
}
