% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-bridges.R
\name{as_df}
\alias{as_df}
\alias{as_df.Coo}
\alias{as_df.Coe}
\alias{as_df.PCA}
\alias{as_df.LDA}
\title{Turn Momocs objects into tydy data_frames}
\usage{
as_df(x, ...)

\method{as_df}{Coo}(x, ...)

\method{as_df}{Coe}(x, ...)

\method{as_df}{PCA}(x, retain, ...)

\method{as_df}{LDA}(x, retain, ...)
}
\arguments{
\item{x}{an object, typically a Momocs object}

\item{...}{useless here}

\item{retain}{numeric for use with \link{scree} methods. Defaut to all. If \verb{<1},
enough axes to retain this proportion of variance; if \verb{>1}, this number of axes.}
}
\value{
a \link[dplyr:data_frame]{dplyr::data_frame}
}
\description{
Used in particular for compatibility with the \code{tidyverse}
}
\examples{
# first, some (baby) objects
b <- bot \%>\% coo_sample(12)
bf <- b \%>\% efourier(5, norm=TRUE)
# Coo object
b \%>\% as_df
# Coe object
bf \%>\% as_df

# PCA object
bf \%>\% PCA \%>\% as_df     # all PCs by default
bf \%>\% PCA \%>\% as_df(2) # or 2
bf \%>\% PCA \%>\% as_df(0.99) # or enough for 99\%

# LDA object
bf \%>\% LDA(~fake) \%>\% as_df
# same options apply
}
\seealso{
Other bridges functions: 
\code{\link{bridges}},
\code{\link{complex}},
\code{\link{export}()}
}
\concept{bridges functions}
