% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-MSHAPES.R
\name{plot_MSHAPES}
\alias{plot_MSHAPES}
\title{Pairwise comparison of a list of shapes}
\usage{
plot_MSHAPES(x, draw_fun, size, palette)
}
\arguments{
\item{x}{a list of shapes (eg as returned by \link{MSHAPES})}

\item{draw_fun}{one of \link{draw_outline}, \link{draw_curves}, \link{draw_landmarks}.
When the result of \link{MSHAPES} is passed, detected based on \verb{$Coe}, otherwise default to \code{draw_curves}.}

\item{size}{numeric shrinking factor for shapes (and \link{coo_template};
3/4 by default)}

\item{palette}{on of \link{palettes}}
}
\value{
a plot
}
\description{
"Confusion matrix" of a list of shapes. See examples.
}
\note{
Directly inspired by Chitwood et al. (2016) in \emph{New Phytologist}
}
\examples{
x <- bot \%>\% efourier(6) \%>\% MSHAPES(~type)

# custom colors
x \%>\% plot_MSHAPES(palette=pal_manual(c("darkgreen", "orange")))

# also works on list of shapes, eg:
leaves <- shapes \%>\% slice(grep("leaf", names(shapes))) \%$\% coo
class(leaves)
leaves \%>\% plot_MSHAPES()

# or
shapes \%>\%
# subset and degrade
slice(1:12) \%>\% coo_sample(60) \%$\%  # grab the coo
    coo \%>\%
    plot_MSHAPES()
}
