% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{rm_harm}
\alias{rm_harm}
\title{Removes harmonics from Coe objects}
\usage{
rm_harm(x, drop = 1)
}
\arguments{
\item{x}{Coe object}

\item{drop}{numeric number of harmonics to drop}
}
\value{
a Momocs object of same class
}
\description{
Useful to drop harmonics on Coe objects. Should only work for
Fourier-based approached since it looks for \code{[A-D][1-drop]} pattern.
}
\examples{
data(bot)
bf <- efourier(bot)
colnames(rm_harm(bf, 1)$coe)
}
\seealso{
Other handling functions: 
\code{\link{arrange}()},
\code{\link{at_least}()},
\code{\link{chop}()},
\code{\link{combine}()},
\code{\link{dissolve}()},
\code{\link{fac_dispatcher}()},
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{rescale}()},
\code{\link{rm_missing}()},
\code{\link{rm_uncomplete}()},
\code{\link{rw_fac}()},
\code{\link{sample_frac}()},
\code{\link{sample_n}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{subsetize}()}
}
\concept{handling functions}
