% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeDataFrame.R
\name{MakeFrame}
\alias{MakeFrame}
\title{Conversion of MonteCarlo outputs to data.frame.}
\usage{
MakeFrame(output)
}
\arguments{
\item{output}{A \code{MonteCarlo} object returned by the \code{MonteCarlo()} function.}
}
\value{
A data.frame that contains the simulation results.
}
\description{
\code{MakeFrame} takes the output of \code{MonteCarlo} as its argument and returns a 
data.frame that contains the simulation results.
}
\details{
Each row of the data.frame contains the values returned by \code{func} for one repetition of the simulation 
and the respective values of the parameters.
}
\examples{
test_func<-function(n,loc,scale){
 sample<-rnorm(n, loc, scale)
 stat<-sqrt(n)*mean(sample)/sd(sample)
 decision<-abs(stat)>1.96
 return(list("decision"=decision, "stat"=stat))
}

n_grid<-c(50,100,250,500)
loc_grid<-c(0,1)
scale_grid<-c(1,2)

param_list=list("n"=n_grid, "loc"=loc_grid, "scale"=scale_grid)
erg<-MonteCarlo(func=test_func, nrep=250, param_list=param_list, ncpus=1)
df<-MakeFrame(erg)
head(df)

library(dplyr)
library(ggplot2)
tbl <- tbl_df(df)
ggplot(filter(tbl, loc==0)) + geom_density(aes(x=stat, col=factor(n)))

}

