\name{tanplan}
\alias{tanplan}
\alias{crossp}

\title{
calculate the orthogonal complement of a 3D-vector}
\description{
calculate the orthogonal complement of a 3D-vector or the
3D-crossproduct, finding an orthogonal vector to a plane in 3D.}

\usage{
tanplan(x)
crossp(x,y)

}
\arguments{
  \item{x}{vector of length 3.
  }
  \item{y}{vector of length 3.
  }
}

\value{
  tanplan:
  
  \item{y }{vector orthogonal to x}
  \item{z }{vector orthogonal to x and y}

  crossp: returns a vector of length 3.
}
\examples{
require(rgl)

x <- c(1,0,0)
y <- c(0,1,0)

#example tanplan
z <- tanplan(x)
#visualize result
lines3d(rbind(0, x), col=2, lwd=2)
## show complement
lines3d(rbind(z$y, 0, z$z), col=3, lwd=2)

# example crossp
z <- crossp(x, y)
# show x and y
lines3d(rbind(x, 0, y), col=2, lwd=2)
# show z
lines3d(rbind(0, z), col=3, lwd=2)
}
\author{
Stefan Schlager}
