% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angleTest.r
\name{angleTest}
\alias{angleTest}
\title{Test whether the direction of two vectors is similar}
\usage{
angleTest(x, y)
}
\arguments{
\item{x}{vector}

\item{y}{vector}
}
\value{
a list with
\item{angle}{angle between vectors}
\item{p.value}{p-value for the probability that the angle between two random vectors is smaller or equal to the one calculatted from x and y}
}
\description{
Test whether the direction of two vectors is similar
}
\details{
Under the assumption of all (normalized) n-vectors being represented by an n-dimensional hypersphere, the probability of the angle between two vectors is <= the measured values can be estimated as the area of a cap defined by that angle and divided by the hypersphere's complete surface area.
}
\examples{
x <- c(1,0); y <- c(1,1) # for a circle this should give us p = 0.25 as the angle between vectors
##  is pi/4 and for any vector the segment +-pi/4 covers a quarter of the circle 
angleTest(x,y)
}
\references{
S. Li , 2011. Concise Formulas for the Area and Volume of a Hyperspherical Cap. Asian Journal of Mathematics & Statistics, 4: 66-70.
}

