% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relwarps.r
\name{predictRelWarps}
\alias{predictRelWarps}
\title{predict relative warps for data not included in the training data set}
\usage{
predictRelWarps(x, newdata, noalign = FALSE)
}
\arguments{
\item{x}{output from \code{relWarps}}

\item{newdata}{k x m x n array holding new landmark data}

\item{noalign}{logical: if TRUE, data is assumed to be already aligned to training data and alignment is skipped.}
}
\value{
returns a list containing
\item{bescores }{relative warp scores (PC-scores if \code{alpha = 0})}
\item{uniscores }{uniform scores, NULL if  \code{alpha = 0}}
}
\description{
predict relative warps for data not included in the training data set
}
\details{
This function aligns the new data to the mean from \code{x} and transforms it into the relative warp space computed from the training data.
}
\examples{
data(boneData)
set.seed(42)
training <- sample(1:80,size=60)
rW1 <- relWarps(boneLM[,,training], alpha = -1)
## predict scores for the entire sample
predAll <- predictRelWarps(rW1,boneLM)

## now compare the scores predicted scores to the original ones
layout(matrix(1:4,2,2))
for (i in 1:2) {
  plot(rW1$bescores[,i],predAll$bescores[training,i],main=paste("RW",i))
  plot(rW1$uniscores[,i],predAll$uniscores[training,i],main=paste("UC",i))
}
}
