% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_LifeTable.R
\name{LifeTable}
\alias{LifeTable}
\title{Life Table Function}
\usage{
LifeTable(x, Dx = NULL, Ex = NULL,
             mx = NULL,
             qx = NULL,
             lx = NULL,
             dx = NULL,
             sex = NULL,
             lx0 = 1e+05)
}
\arguments{
\item{x}{vector of age at the beginning of the age classes}

\item{Dx}{object containing death counts. An element of the \code{Dx} object, 
represents the number of deaths during the year to persons aged x to x+n.}

\item{Ex}{exposure in the period. \code{Ex} can be approximated by the 
mid-year population aged x to x+n}

\item{mx}{age-specific death rates}

\item{qx}{probability of dying between age x and x+n.}

\item{lx}{probability to survive up until age x}

\item{dx}{life table death counts at age x}

\item{sex}{sex of the population considered here. Default: \code{NULL}. 
This argument affects the first two values in the life table ax column. 
If sex is specified the values are computed based on Coale-Demeny method 
and are slightly different for males than for females. 
Options: \code{NULL, male, female, total}.}

\item{lx0}{radix. Default: 100 000}
}
\value{
The output is of class \code{LifeTable} with the components:

\item{lt}{ computed life table}

\item{call}{ a call in which all of the specified arguments are 
specified by their full names.}

\item{process_date}{ time stamp}
}
\description{
Construct either a full or abridge life table with various input choices like:
death counts and mid-interval population estimates \code{(Dx, Ex)} or 
age-specific death rates \code{(mx)} or death probabilities \code{(qx)}
or survivorship curve \code{(lx)} or a distribution of deaths \code{(dx)}.
If one of these options are specified, the other can be ignored.
}
\details{
The input data can be of an object of class: 
\code{numeric}, \code{matrix} or \code{data.frame}.
}
\examples{
# Example 1 --- Full life tables with different inputs ---
 
y  <- 1900
x  <- as.numeric(rownames(ahmd$mx))
Dx <- ahmd$Dx[, paste(y)]
Ex <- ahmd$Ex[, paste(y)]

LT1 <- LifeTable(x, Dx = Dx, Ex = Ex)
LT2 <- LifeTable(x, mx = LT1$lt$mx)
LT3 <- LifeTable(x, qx = LT1$lt$qx)
LT4 <- LifeTable(x, lx = LT1$lt$lx)
LT5 <- LifeTable(x, dx = LT1$lt$dx)

LT1
LT5
ls(LT5) 

# Example 2 --- Compute multiple life tables at once ---

LTs = LifeTable(x, mx = ahmd$mx)
LTs
# A warning is printed if the input contains missing values. 
# Some of the missing values can be handled by the function.

#' 
# Example 3 --- Abridge life table ------------

x  = c(0, 1, seq(5, 110, by = 5))
mx = c(.053, .005, .001, .0012, .0018, .002, .003, .004, 
       .004, .005, .006, .0093, .0129, .019, .031, .049, 
       .084, .129, .180, .2354, .3085, .390, .478, .551)
lt = LifeTable(x, mx = mx, sex = "female")
lt

}
