% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityTable.mixed.R
\docType{class}
\name{mortalityTable.mixed-class}
\alias{mortalityTable.mixed-class}
\alias{mortalityTable.mixed}
\title{Class mortalityTable.mixed - Life table as a mix of two life tables}
\description{
A cohort life table obtained by mixing two life tables with the given weights.
Typically, when only gender-specific tables are available, unisex tables
are generated by mixing the two gender-specific tables for males and for
females with a pre-defined, constant proportion (e.g. 60:30 or 40:60,
depending on the portfolio and on the security margins).
}
\section{Slots}{

\describe{
\item{\code{table1}}{The first \code{mortalityTable}}

\item{\code{table2}}{The second \code{mortalityTable}}

\item{\code{weight1}}{The weight of the first mortality table}

\item{\code{weight2}}{The weight of the second mortality table}

\item{\code{loading}}{Additional security loading}
}}

\examples{
mortalityTables.load("Austria_Annuities_AVOe2005R")
# Generate a unisex table with mixing relation 60:40 from male + female tables
AVOe2005R.myUnisex = mortalityTable.mixed(
    table1 = AVOe2005R.male, table2 = AVOe2005R.female,
    weight1 = 0.6, weight2 = 0.4,
    name = "My custom AVOe 2005R unisex (60:40)")
plot(AVOe2005R.myUnisex, AVOe2005R.male, AVOe2005R.female, Period = 2017)
}
