% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R, R/mortalityTable.observed.R
\name{mT.round}
\alias{mT.round}
\alias{mT.round,mortalityTable-method}
\alias{mT.round,mortalityTable.period-method}
\alias{mT.round,mortalityTable.trendProjection-method}
\alias{mT.round,mortalityTable.improvementFactors-method}
\alias{mT.round,array-method}
\alias{mT.round,list-method}
\alias{mT.round,pensionTable-method}
\alias{mT.round,mortalityTable.observed-method}
\title{Round all components of a mortality table to the given number of digits}
\usage{
mT.round(object, digits = 8)

\S4method{mT.round}{mortalityTable}(object, digits = 8)

\S4method{mT.round}{mortalityTable.period}(object, digits = 8)

\S4method{mT.round}{mortalityTable.trendProjection}(object, digits = 8)

\S4method{mT.round}{mortalityTable.improvementFactors}(object, digits = 8)

\S4method{mT.round}{array}(object, digits = 8)

\S4method{mT.round}{list}(object, digits = 8)

\S4method{mT.round}{pensionTable}(object, digits = 8)

\S4method{mT.round}{mortalityTable.observed}(object, digits = 8)
}
\arguments{
\item{object}{The mortalityTable object to be rounded (or a list / array of mortalityTable object)}

\item{digits}{the desired number of significant digits to round to}
}
\description{
The function mt.round rounds all components (base table, potentially also
trend functions or yearly improvement factors) to the given number of
numerical digits. For pensionTable objects, the function is applied to all components
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable}: Round the given mortalityTable to a given number of digits

\item \code{mortalityTable.period}: Round the given period mortality table to a given number of digits (base table and loadings)

\item \code{mortalityTable.trendProjection}: Round the given mortalityTable with trend projection to a given number of digits (base table, loadings and trend(s))

\item \code{mortalityTable.improvementFactors}: Round the given mortalityTable with improvement factors to a given number of digits (base table, loadings and improvement factors)

\item \code{array}: Round the mortalityTables stored in an array to a given number of digits

\item \code{list}: Round the mortalityTables stored in a list to a given number of digits

\item \code{pensionTable}: Round all components of a pensionTable to a given number of digits

\item \code{mortalityTable.observed}: Return the life table with the values rounded to the given number of digits
}}

\examples{
mortalityTables.load("Austria_Census")
AT.rounded1 = mT.round(mort.AT.census.2011.male, 1)
AT.rounded2 = mT.round(mort.AT.census.2011.male, 2)
AT.rounded3 = mT.round(mort.AT.census.2011.male, 3)
plotMortalityTables(mort.AT.census.2001.male,
                    mT.setName(AT.rounded1, "rounded to 1 digit"),
                    mT.setName(AT.rounded3, "rounded to 3 digits"))

}
