% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R, R/mortalityTable.observed.R
\name{mT.cleanup}
\alias{mT.cleanup}
\alias{mT.cleanup,mortalityTable-method}
\alias{mT.cleanup,mortalityTable.period-method}
\alias{mT.cleanup,mortalityTable.trendProjection-method}
\alias{mT.cleanup,array-method}
\alias{mT.cleanup,list-method}
\alias{mT.cleanup,pensionTable-method}
\alias{mT.cleanup,mortalityTable.observed-method}
\title{Remove all non-essential data (raw data, etc.) from a mortalityTable object}
\usage{
mT.cleanup(object)

\S4method{mT.cleanup}{mortalityTable}(object)

\S4method{mT.cleanup}{mortalityTable.period}(object)

\S4method{mT.cleanup}{mortalityTable.trendProjection}(object)

\S4method{mT.cleanup}{array}(object)

\S4method{mT.cleanup}{list}(object)

\S4method{mT.cleanup}{pensionTable}(object)

\S4method{mT.cleanup}{mortalityTable.observed}(object)
}
\arguments{
\item{object}{The mortalityTable object to be cleaned.}
}
\description{
The function mt.cleanup removes all non-essential data from a given mortalityTable
object.
}
\details{
Mortality tables are often generated from raw data, that is smoothed, extrapolated,
etc. The mortalityTable class and its implementations can internally store the
raw probabilities and the intermediate results and parameters. This method
removes those information. All essential information (base table, ages,
trend functions, etc.) are preserved.

Removed information includes:
  * all elements of the \code{object@data} list, except for \code{dim}
  * exposures
  * names of named age, deathProbs and trend vectors

For mortality tables with other mortalityTable components (like pension tables
or mixed tables), all components are cleaned.
}
\section{Methods (by class)}{
\itemize{
\item \code{mT.cleanup(mortalityTable)}: Clean up and remove all non-essential data from the mortalityTable object

\item \code{mT.cleanup(mortalityTable.period)}: Clean up and remove all non-essential data from the mortalityTable.period object

\item \code{mT.cleanup(mortalityTable.trendProjection)}: Clean up and remove all non-essential data from the mortalityTable.trendProjection object

\item \code{mT.cleanup(array)}: Clean up and remove all non-essential data from the mortalityTable objects stored in the array

\item \code{mT.cleanup(list)}: Clean up and remove all non-essential data from the mortalityTable objects stored in the list

\item \code{mT.cleanup(pensionTable)}: Clean up and remove all non-essential data from the mortalityTable objects stored in the array

\item \code{mT.cleanup(mortalityTable.observed)}: Clean up the internal data of the mortality table

}}
\examples{
mortalityTables.load("Austria_Census")
# Whittaker-Henderson smoothing stores the raw input and the weights in the
# \code{data} slot of the table:
AT.smoothed = whittaker.mortalityTable(mort.AT.census.2011.male)
AT.smoothed@data$rawProbs
AT.smoothed@data$whittaker

# cleaning up the table removes those non-essential information again:
AT.smoothed.clean = mT.cleanup(AT.smoothed)
AT.smoothed.clean@data$rawProbs
AT.smoothed.clean@data$whittaker

}
