% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{SummaryTable}
\alias{SummaryTable}
\title{Create a summary table of Mplus model statistics}
\usage{
SummaryTable(modelList, type = c("screen", "popup", "html", "latex",
  "markdown"), filename = "", keepCols, dropCols, sortBy, caption = "",
  display = FALSE, ..., include.rownames = FALSE)
}
\arguments{
\item{modelList}{A list of models returned from the \code{extractModelSummaries} function.}

\item{type}{A character vector indicating the type of output format to be generated.  One of:
\dQuote{screen}, \dQuote{popup}, \dQuote{html}, \dQuote{latex}, or \dQuote{markdown}. Screen results in a simple
summary table being sent to the R console.}

\item{filename}{The name of the file to be created. Can be an absolute or relative path. If \code{filename}
is a relative path or just the filename, then it is assumed that the file resides in the working
directory \code{getwd()}. Example: \code{"Mplus Summary.html"}.  By default, no filename is given,
which results in the output being sent to the console.  Note that currently, filename only has an effect for
\dQuote{html} and \dQuote{latex}.}

\item{keepCols}{A vector of character strings indicating which columns/variables to display in the summary.
Only columns included in this list will be displayed (all others excluded). By default, \code{keepCols}
is: \code{c("Title", "LL", "Parameters", "AIC", "AICC", "BIC", "RMSEA_Estimate")}.
Example: \code{c("Title", "LL", "AIC", "CFI")}}

\item{dropCols}{A vector of character strings indicating which columns/variables to omit from the summary.
Any column not included in this list will be displayed. By default, \code{dropCols} is \code{NULL}.
Example: \code{c("InputInstructions", "TLI")}}

\item{sortBy}{optional. Field name (as character string) by which to sort the table. Typically an information criterion
(e.g., "AIC" or "BIC") is used to sort the table. Defaults to "AICC".}

\item{caption}{A character string, the caption to be given to the table.  Currently only
applies to types \dQuote{html}, \dQuote{latex}, and \dQuote{markdown}.}

\item{display}{optional logical (defaults to \code{FALSE}). This parameter specifies whether to display the
table upon creation (\code{TRUE} or \code{FALSE}).}

\item{include.rownames}{optional logical whether to include rownames or not.}

\item{\ldots}{additional arguments passed on to specific formatting types.}
}
\value{
Invisibly returns the summary table, which can be used if the printing options avaiable are not sufficient.
}
\description{
Creates output (optionally sent to a file) containing a summary table of model fit statistics
extracted using the \code{extractModelSummaries} function.
By default, the following summary statistics are included:
\code{Title, LL, Parameters, AIC, AICC, BIC, RMSEA_Estimate},
but these are customizable using the \code{keepCols} and \code{dropCols} parameters.
}
\note{
You must choose between \code{keepCols} and \code{dropCols} because it is not sensible to use these
  together to include and exclude columns. The function will error if you include both parameters.
}
\examples{
\dontrun{
 m1 <- mplusObject(TITLE = "Reduced",
  MODEL = "mpg ON wt;", rdata = mtcars)
 m1.fit <- mplusModeler(m1, "mtcars.dat", run = 1L)
 m2 <- mplusObject(TITLE = "Full",
  MODEL = "mpg ON wt hp qsec;", rdata = mtcars)
 m2.fit <- mplusModeler(m2, "mtcars.dat", run = 1L)

 SummaryTable(list(m1.fit, m2.fit))
 SummaryTable(list(m1.fit, m2.fit), type = "popup")
 SummaryTable(list(m1.fit, m2.fit), type = "markdown",
   keepCols = c("Title", "Parameters", "LL", "AIC", "CFI", "SRMR"),
   caption = "Table of Model Fit Statistics",
   split.tables = 200)

 # remove files
 unlink("mtcars.dat")
 unlink("mtcars.inp")
 unlink("mtcars.out")
 unlink("Mplus Run Models.log")
}
}
\seealso{
\code{\link{extractModelSummaries}}
}
\author{
Joshua F. Wiley based on code by Michael Hallquist
}
\keyword{interface}
