% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtures.R
\name{plotLTA}
\alias{plotLTA}
\title{Plot latent transition model}
\usage{
plotLTA(mplusModel, node_stroke = 2, max_edge_width = 2,
  node_labels = "variable.class", x_labels = "variable")
}
\arguments{
\item{mplusModel}{A single Mplus model object, returned by . This
function additionally requires the model to be a mixture model with multiple
categorical latent variables.}

\item{node_stroke}{Integer. Base stroke thickness for nodes. Set to 
\code{NULL} to give each node the same stroke thickness.}

\item{max_edge_width}{Integer. Maximum width of edges.}

\item{node_labels}{Character vector, defaults to \code{"variable.class"}, 
which labels each node by the name of the variable, and the number of the 
class it represents. Set to \code{"class"} to display only class numbers, or
provide a named character vector where the names correspond to original class
labels, and the values correspond to their substitute values.}

\item{x_labels}{Character vector, defaults to \code{"variable"}, which labels
the x-axis with the names of the categorical latent variables. Set to
\code{NULL} to remove axis labels, or provide a named character vector where
the names correspond to original x-axis labels, and the values correspond to
their substitute values.}
}
\value{
An object of class 'ggplot'.
}
\description{
Plots latent transition probabilities and classification probabilities for
a single latent transition model (a model with multiple categorical latent
variables, regressed on one another). Stroke thickness of nodes represents
the proportion of cases most likely assigned to that class, with wider 
strokes representing greater probability. Edge thickness and transparency
represent the probability of making a particular transition (left to right),
with thicker/darker edges representing greater probability.
}
\examples{
\dontrun{
data <- read.table("http://statmodel.com/usersguide/chap8/ex8.13.dat")[,c(1:10)]
names(data) <- c("u11", "u12", "u13", "u14", "u15", "u21", "u22", "u23", "u24", "u25")
createMixtures(
classes = 2,
filename_stem = "dating",
model_overall = "c2 ON c1;",
model_class_specific = c(
"[u11$1] (a{C});  [u12$1] (b{C});  [u13$1] (c{C});  [u14$1] (d{C});  [u15$1] (e{C});",
"[u21$1] (a{C});  [u22$1] (b{C});  [u23$1] (c{C});  [u24$1] (d{C});  [u25$1] (e{C});"
),
rdata = data,
ANALYSIS = "PROCESSORS IS 2;  LRTSTARTS (0 0 40 20);  PARAMETERIZATION = PROBABILITY;",
VARIABLE = "CATEGORICAL = u11-u15 u21-u25;"
)
runModels(filefilter = "dating")
results <- readModels(filefilter = "dating")
plotLTA(results)
}
}
\author{
Caspar J. van Lissa
}
\keyword{internal}
