% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{weighted_spring_model}
\alias{weighted_spring_model}
\title{Plot the relationship of integration sites as a graph.}
\usage{
weighted_spring_model(
  readouts,
  mapping,
  gt,
  sim = get_similarity_matrix(readouts, self = NA, upper = FALSE, parallel = FALSE),
  rec_pal = NULL,
  clone_pal = NULL,
  line_color = "#009900FF",
  seed = 4711L
)
}
\arguments{
\item{readouts}{The integration site readouts that this spring model is
based on.}

\item{mapping}{The reconstructed mapping from clones to integration sites.
This is represented as a matrix with two columns "IS" and
"Clone".}

\item{gt}{The ground truth mapping from clones to integration sites, if
available. Same structure as `mapping`.}

\item{sim}{The similarity matrix holding the similarities between all
integration sites.}

\item{rec_pal}{A named vector color palette holding colors for each
integration site. Will be used as the fill color for the
nodes.}

\item{clone_pal}{A named vector color palette holding colors for each
integration site. Will be used as the line color for the
nodes.}

\item{line_color}{The line color to use for the edges of the graph.}

\item{seed}{A seed that will be set using `set.seed()` to ensure
consistent behaviour with the layout that is provided by
`igraph`.}
}
\value{
A ggplot object that contains the generated graph.
}
\description{
Integration sites will be represented as nodes in the graph, while their
mutual similarity is indicated by the line size and opaqueness of the lines
between them.
}
