% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPT.R
\name{NPT_plot}
\alias{NPT_plot}
\title{Plot results from nested principal component analysis}
\usage{
NPT_plot(pca_obj, group = NULL)
}
\arguments{
\item{pca_obj}{An rda object returned by the second-level PCA in the NPT function.}

\item{group}{A vector or factor specifying the grouping of samples.}
}
\value{
A ggplot object representing a biplot of species scores and sample points.
}
\description{
This function creates a visualization of the results from the nested principal
component analysis (NPT function) for ecological niche periodicity.
}
\details{
The function creates a biplot that includes:
\enumerate{
\item Sample points colored by group
\item Species scores represented as arrows
\item Species labels positioned using ggrepel to avoid overlapping
}

The plot also includes dashed lines at x=0 and y=0, and displays the percentage
of variance explained by each principal component on the axes.
}
\examples{
data(PFF)
PFF[,3:20] <- log(PFF[,3:20])
PFF <- na.omit(PFF)
traits_dimension <- list(
  grow = c("SLA","Leaf_area","LDMC","SRL","Leaf_Nmass","Leaf_Pmass","Root_Nmass"),
  survive = c("Height","Leaf_Cmass","Root_Cmass","Leaf_CN","Leaf_NP","Leaf_CP","Root_CN"),
  reproductive = c("SeedMass","FltDate","FltDur")
)
npt_result <- NPT(data = PFF, dimension = traits_dimension)
dev.new() # A window that is too small will interfere with the drawing.
          # Optionally, you can set the drawing window to pop up automatically.
NPT_plot(npt_result$result)
NPT_plot(npt_result$result, PFF$family)

}
\references{
\enumerate{
\item Winemiller, K. O., Fitzgerald, D. B., Bower, L. M., & Pianka, E. R. (2015). Functional traits, convergent evolution, and periodic tables of niches. Ecology letters, 18(8), 737-751. https://doi.org/10.1111/ele.12462
\item Yu, R., Huang, J., Xu, Y., Ding, Y., & Zang, R. (2020). Plant functional niches in forests across four climatic zones: Exploring the periodic table of niches based on plant functional traits. Frontiers in Plant Science, 11, 841. https://doi.org/10.3389/fpls.2020.00841
}
}
