/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.candidate;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Lock;
import net.myrrix.common.ClassUtils;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.online.candidate.CandidateFilter;
import net.myrrix.online.candidate.IdentityCandidateFilter;
import net.myrrix.online.candidate.LocationSensitiveHash;

public final class CandidateFilterFactory {
    private CandidateFilterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CandidateFilter buildCandidateFilter(FastByIDMap<float[]> Y, Lock yReadLock) {
        Preconditions.checkNotNull(Y);
        if (!Y.isEmpty()) {
            yReadLock.lock();
            try {
                String candidateFilterCustomClassString = System.getProperty("model.candidateFilter.customClass");
                if (candidateFilterCustomClassString != null) {
                    CandidateFilter candidateFilter = ClassUtils.loadInstanceOf(candidateFilterCustomClassString, CandidateFilter.class, new Class[]{FastByIDMap.class}, new Object[]{Y});
                    return candidateFilter;
                }
                if (LocationSensitiveHash.LSH_SAMPLE_RATIO < 1.0) {
                    LocationSensitiveHash locationSensitiveHash = new LocationSensitiveHash(Y);
                    return locationSensitiveHash;
                }
            }
            finally {
                yReadLock.unlock();
            }
        }
        return new IdentityCandidateFilter(Y);
    }
}

