/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client;

import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.CliFactory;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import net.myrrix.client.CLIArgs;
import net.myrrix.client.CLICommand;
import net.myrrix.client.ClientRecommender;
import net.myrrix.client.MyrrixClientConfiguration;
import net.myrrix.client.translating.TranslatedRecommendedItem;
import net.myrrix.client.translating.TranslatingClientRecommender;
import net.myrrix.client.translating.TranslatingRecommender;
import net.myrrix.common.LangUtils;
import net.myrrix.common.OneWayMigrator;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.log.MemoryHandler;
import net.myrrix.common.random.MemoryIDMigrator;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CLI {
    private static final Logger log = LoggerFactory.getLogger(CLI.class);

    private CLI() {
    }

    public static void main(String[] args) throws Exception {
        CLICommand command;
        CLIArgs cliArgs;
        try {
            cliArgs = CliFactory.parseArguments(CLIArgs.class, args);
        }
        catch (ArgumentValidationException ave) {
            CLI.printHelp(ave.getMessage());
            return;
        }
        List<String> programArgsList = cliArgs.getCommands();
        if (programArgsList == null || programArgsList.isEmpty()) {
            CLI.printHelp("Specify a command: " + Arrays.toString((Object[])CLICommand.values()));
            return;
        }
        String[] commandArgs = programArgsList.toArray(new String[programArgsList.size()]);
        try {
            command = CLICommand.valueOf(commandArgs[0].toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            CLI.printHelp(iae.getMessage());
            return;
        }
        if (cliArgs.isVerbose()) {
            MemoryHandler.setSensibleLogFormat();
            CLI.enableDebugLoggingIn(CLI.class, ClientRecommender.class, TranslatingClientRecommender.class);
            log.debug("{}", (Object)cliArgs);
        }
        MyrrixClientConfiguration config = CLI.buildConfiguration(cliArgs);
        ClientRecommender recommender = new ClientRecommender(config);
        boolean translateUser = cliArgs.isTranslateUser();
        String translateFileName = cliArgs.getTranslateItem();
        boolean translateItem = translateFileName != null;
        TranslatingClientRecommender translatingRecommender = null;
        if (translateUser || translateItem) {
            OneWayMigrator userTranslator = translateUser ? new OneWayMigrator() : null;
            MemoryIDMigrator itemTranslator = translateItem ? new MemoryIDMigrator() : null;
            translatingRecommender = new TranslatingClientRecommender(recommender, userTranslator, itemTranslator);
            if (translateFileName != null && !"oneWay".equals(translateFileName)) {
                File translateFile = new File(translateFileName);
                translatingRecommender.addItemIDs(translateFile);
            }
        }
        try {
            switch (command) {
                case SETPREFERENCE: {
                    CLI.doSetPreference(commandArgs, recommender, translatingRecommender);
                    break;
                }
                case REMOVEPREFERENCE: {
                    CLI.doRemovePreference(commandArgs, recommender, translatingRecommender);
                    break;
                }
                case SETUSERTAG: {
                    CLI.doSetUserTag(commandArgs, recommender, translatingRecommender);
                    break;
                }
                case SETITEMTAG: {
                    CLI.doSetItemTag(commandArgs, recommender, translatingRecommender);
                    break;
                }
                case INGEST: {
                    CLI.doIngest(commandArgs, recommender, translatingRecommender);
                    break;
                }
                case ESTIMATEPREFERENCE: {
                    CLI.doEstimatePreference(commandArgs, recommender, translatingRecommender);
                    break;
                }
                case ESTIMATEFORANONYMOUS: {
                    CLI.doEstimateForAnonymous(commandArgs, recommender, translatingRecommender);
                    break;
                }
                case RECOMMEND: {
                    CLI.doRecommend(cliArgs, commandArgs, recommender, translatingRecommender);
                    break;
                }
                case RECOMMENDTOANONYMOUS: {
                    CLI.doRecommendToAnonymous(cliArgs, commandArgs, recommender, translatingRecommender);
                    break;
                }
                case RECOMMENDTOMANY: {
                    CLI.doRecommendToMany(cliArgs, commandArgs, recommender, translatingRecommender);
                    break;
                }
                case MOSTPOPULARITEMS: {
                    CLI.doMostPopularItems(cliArgs, commandArgs, recommender, translatingRecommender);
                    break;
                }
                case MOSTSIMILARITEMS: {
                    CLI.doMostSimilarItems(cliArgs, commandArgs, recommender, translatingRecommender);
                    break;
                }
                case SIMILARITYTOITEM: {
                    CLI.doSimilarityToItem(cliArgs, commandArgs, recommender, translatingRecommender);
                    break;
                }
                case RECOMMENDEDBECAUSE: {
                    CLI.doRecommendedBecause(cliArgs, commandArgs, recommender, translatingRecommender);
                    break;
                }
                case REFRESH: {
                    CLI.doRefresh(commandArgs, recommender);
                    break;
                }
                case ISREADY: {
                    CLI.doIsReady(commandArgs, recommender);
                    break;
                }
                case GETALLUSERIDS: {
                    CLI.doGetAllIDs(commandArgs, recommender, translatingRecommender, true);
                    break;
                }
                case GETALLITEMIDS: {
                    CLI.doGetAllIDs(commandArgs, recommender, translatingRecommender, false);
                    break;
                }
                case GETNUMUSERCLUSTERS: {
                    CLI.getNumClusters(commandArgs, recommender, true);
                    break;
                }
                case GETNUMITEMCLUSTERS: {
                    CLI.getNumClusters(commandArgs, recommender, false);
                    break;
                }
                case GETUSERCLUSTER: {
                    CLI.doGetCluster(commandArgs, recommender, translatingRecommender, true);
                    break;
                }
                case GETITEMCLUSTER: {
                    CLI.doGetCluster(commandArgs, recommender, translatingRecommender, false);
                }
            }
        }
        catch (ArgumentValidationException ave) {
            CLI.printHelp(ave.getMessage());
        }
    }

    private static void doGetAllIDs(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender, boolean isUser) throws TasteException {
        if (programArgs.length != 1) {
            throw new ArgumentValidationException("no arguments");
        }
        if (translatingRecommender == null) {
            FastIDSet ids = isUser ? recommender.getAllUserIDs() : recommender.getAllItemIDs();
            LongPrimitiveIterator it = ids.iterator();
            while (it.hasNext()) {
                System.out.println(Long.toString(it.nextLong()));
            }
        } else {
            if (isUser) {
                throw new UnsupportedOperationException();
            }
            Collection<String> ids = translatingRecommender.getAllItemIDs();
            for (String id : ids) {
                System.out.println(id);
            }
        }
    }

    private static void getNumClusters(String[] programArgs, ClientRecommender recommender, boolean isUser) throws TasteException {
        if (programArgs.length != 1) {
            throw new ArgumentValidationException("no arguments");
        }
        int count = isUser ? recommender.getNumUserClusters() : recommender.getNumItemClusters();
        System.out.println(count);
    }

    private static void doGetCluster(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender, boolean isUser) throws TasteException {
        if (programArgs.length != 2) {
            throw new ArgumentValidationException("args are n");
        }
        int n = Integer.parseInt(programArgs[1]);
        if (translatingRecommender == null) {
            FastIDSet ids = isUser ? recommender.getUserCluster(n) : recommender.getItemCluster(n);
            LongPrimitiveIterator it = ids.iterator();
            while (it.hasNext()) {
                System.out.println(Long.toString(it.nextLong()));
            }
        } else {
            Collection<String> ids = isUser ? translatingRecommender.getUserCluster(n) : translatingRecommender.getItemCluster(n);
            for (String id : ids) {
                System.out.println(id);
            }
        }
    }

    private static void doIsReady(String[] programArgs, ClientRecommender recommender) throws TasteException {
        if (programArgs.length != 1) {
            throw new ArgumentValidationException("no arguments");
        }
        System.out.println(recommender.isReady());
    }

    private static void doRefresh(String[] programArgs, ClientRecommender recommender) {
        if (programArgs.length != 1) {
            throw new ArgumentValidationException("no arguments");
        }
        recommender.refresh();
    }

    private static void doRecommendedBecause(CLIArgs cliArgs, String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 3) {
            throw new ArgumentValidationException("args are userID itemID");
        }
        int howMany = cliArgs.getHowMany();
        if (translatingRecommender == null) {
            long userID = Long.parseLong(CLI.unquote(programArgs[1]));
            long itemID = Long.parseLong(CLI.unquote(programArgs[2]));
            CLI.output(recommender.recommendedBecause(userID, itemID, howMany));
        } else {
            String userID = CLI.unquote(programArgs[1]);
            String itemID = CLI.unquote(programArgs[2]);
            CLI.outputTranslated(translatingRecommender.recommendedBecause(userID, itemID, howMany));
        }
    }

    private static void doMostPopularItems(CLIArgs cliArgs, String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 1) {
            throw new ArgumentValidationException("no args");
        }
        int howMany = cliArgs.getHowMany();
        if (translatingRecommender == null) {
            CLI.output(recommender.mostPopularItems(howMany));
        } else {
            CLI.outputTranslated(translatingRecommender.mostPopularItems(howMany));
        }
    }

    private static void doMostSimilarItems(CLIArgs cliArgs, String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length < 2) {
            throw new ArgumentValidationException("args are itemID1 [itemID2 [itemID3...]]");
        }
        int howMany = cliArgs.getHowMany();
        List<String> rescorerParamsList = cliArgs.getRescorerParams();
        String[] rescorerParams = rescorerParamsList == null ? null : rescorerParamsList.toArray(new String[rescorerParamsList.size()]);
        String contextUserIDString = cliArgs.getContextUserID();
        if (translatingRecommender == null) {
            long[] itemIDs = new long[programArgs.length - 1];
            for (int i = 1; i < programArgs.length; ++i) {
                itemIDs[i - 1] = Long.parseLong(CLI.unquote(programArgs[i]));
            }
            List<RecommendedItem> result = contextUserIDString == null ? recommender.mostSimilarItems(itemIDs, howMany, rescorerParams, null) : recommender.mostSimilarItems(itemIDs, howMany, rescorerParams, Long.parseLong(contextUserIDString));
            CLI.output(result);
        } else {
            String[] itemIDs = new String[programArgs.length - 1];
            for (int i = 1; i < programArgs.length; ++i) {
                itemIDs[i - 1] = CLI.unquote(programArgs[i]);
            }
            CLI.outputTranslated(translatingRecommender.mostSimilarItems(itemIDs, howMany, rescorerParams, contextUserIDString));
        }
    }

    private static void doSimilarityToItem(CLIArgs cliArgs, String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        float[] result;
        if (programArgs.length < 3) {
            throw new ArgumentValidationException("args are toItemID itemID1 [itemID2 [itemID3...]]");
        }
        String contextUserIDString = cliArgs.getContextUserID();
        if (translatingRecommender == null) {
            long toItemID = Long.parseLong(programArgs[1]);
            long[] itemIDs = new long[programArgs.length - 2];
            for (int i = 2; i < programArgs.length; ++i) {
                itemIDs[i - 2] = Long.parseLong(CLI.unquote(programArgs[i]));
            }
            result = contextUserIDString == null ? recommender.similarityToItem(toItemID, itemIDs) : recommender.similarityToItem(toItemID, itemIDs, (Long)Long.parseLong(contextUserIDString));
        } else {
            String[] itemIDs = new String[programArgs.length - 2];
            System.arraycopy(programArgs, 2, itemIDs, 0, programArgs.length - 2);
            result = translatingRecommender.similarityToItem(programArgs[1], itemIDs, contextUserIDString);
        }
        for (float similarity : result) {
            System.out.println(similarity);
        }
    }

    private static void doRecommendToAnonymous(CLIArgs cliArgs, String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length < 2) {
            throw new ArgumentValidationException("args are itemID1 [itemID2 [itemID3...]]");
        }
        int howMany = cliArgs.getHowMany();
        List<String> rescorerParamsList = cliArgs.getRescorerParams();
        String[] rescorerParams = rescorerParamsList == null ? null : rescorerParamsList.toArray(new String[rescorerParamsList.size()]);
        String contextUserIDString = cliArgs.getContextUserID();
        if (translatingRecommender == null) {
            long[] itemIDs = new long[programArgs.length - 1];
            for (int i = 1; i < programArgs.length; ++i) {
                itemIDs[i - 1] = Long.parseLong(CLI.unquote(programArgs[i]));
            }
            List<RecommendedItem> result = contextUserIDString == null ? recommender.recommendToAnonymous(itemIDs, null, howMany, rescorerParams, null) : recommender.recommendToAnonymous(itemIDs, null, howMany, rescorerParams, Long.parseLong(contextUserIDString));
            CLI.output(result);
        } else {
            String[] itemIDs = new String[programArgs.length - 1];
            for (int i = 1; i < programArgs.length; ++i) {
                itemIDs[i - 1] = CLI.unquote(programArgs[i]);
            }
            CLI.outputTranslated(translatingRecommender.recommendToAnonymous(itemIDs, null, howMany, rescorerParams, contextUserIDString));
        }
    }

    private static void doRecommendToMany(CLIArgs cliArgs, String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length < 2) {
            throw new ArgumentValidationException("args are userID1 [userID2 [userID3...]]");
        }
        int howMany = cliArgs.getHowMany();
        List<String> rescorerParamsList = cliArgs.getRescorerParams();
        String[] rescorerParams = rescorerParamsList == null ? null : rescorerParamsList.toArray(new String[rescorerParamsList.size()]);
        boolean considerKnownItems = cliArgs.isConsiderKnownItems();
        if (translatingRecommender == null) {
            long[] userIDs = new long[programArgs.length - 1];
            for (int i = 1; i < programArgs.length; ++i) {
                userIDs[i - 1] = Long.parseLong(CLI.unquote(programArgs[i]));
            }
            List<RecommendedItem> result = recommender.recommendToMany(userIDs, howMany, considerKnownItems, rescorerParams);
            CLI.output(result);
        } else {
            String[] userIDs = new String[programArgs.length - 1];
            for (int i = 1; i < programArgs.length; ++i) {
                userIDs[i - 1] = CLI.unquote(programArgs[i]);
            }
            CLI.outputTranslated(translatingRecommender.recommendToMany(userIDs, howMany, considerKnownItems, rescorerParams));
        }
    }

    private static void doRecommend(CLIArgs cliArgs, String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 2) {
            throw new ArgumentValidationException("args are userID");
        }
        int howMany = cliArgs.getHowMany();
        List<String> rescorerParamsList = cliArgs.getRescorerParams();
        String[] rescorerParams = rescorerParamsList == null ? null : rescorerParamsList.toArray(new String[rescorerParamsList.size()]);
        boolean considerKnownItems = cliArgs.isConsiderKnownItems();
        if (translatingRecommender == null) {
            long userID = Long.parseLong(CLI.unquote(programArgs[1]));
            CLI.output(recommender.recommend(userID, howMany, considerKnownItems, rescorerParams));
        } else {
            String userID = CLI.unquote(programArgs[1]);
            CLI.outputTranslated(translatingRecommender.recommend(userID, howMany, considerKnownItems, rescorerParams));
        }
    }

    private static void doEstimatePreference(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length < 3) {
            throw new ArgumentValidationException("args are userID itemID1 [itemID2 [itemID3...]]");
        }
        if (translatingRecommender == null) {
            long userID = Long.parseLong(CLI.unquote(programArgs[1]));
            for (int i = 2; i < programArgs.length; ++i) {
                long itemID = Long.parseLong(CLI.unquote(programArgs[i]));
                System.out.println(recommender.estimatePreference(userID, itemID));
            }
        } else {
            String userID = CLI.unquote(programArgs[1]);
            for (int i = 2; i < programArgs.length; ++i) {
                String itemID = CLI.unquote(programArgs[i]);
                System.out.println(translatingRecommender.estimatePreference(userID, itemID));
            }
        }
    }

    private static void doEstimateForAnonymous(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length < 3) {
            throw new ArgumentValidationException("args are toItemID itemID0 [itemID1 [itemID2...]]");
        }
        if (translatingRecommender == null) {
            long toItemID = Long.parseLong(CLI.unquote(programArgs[1]));
            long[] itemIDs = new long[programArgs.length - 2];
            for (int i = 2; i < programArgs.length; ++i) {
                itemIDs[i - 2] = Long.parseLong(CLI.unquote(programArgs[i]));
            }
            System.out.println(recommender.estimateForAnonymous(toItemID, itemIDs));
        } else {
            String toItemID = CLI.unquote(programArgs[1]);
            String[] itemIDs = new String[programArgs.length - 2];
            for (int i = 2; i < programArgs.length; ++i) {
                itemIDs[i - 2] = CLI.unquote(programArgs[i]);
            }
            System.out.println(translatingRecommender.estimateForAnonymous(toItemID, itemIDs));
        }
    }

    private static void doIngest(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length < 2) {
            throw new ArgumentValidationException("args are file1 [file2 [file3...]]");
        }
        for (int i = 1; i < programArgs.length; ++i) {
            File ingestFile = new File(programArgs[i]);
            if (translatingRecommender == null) {
                recommender.ingest(ingestFile);
                continue;
            }
            translatingRecommender.ingest(ingestFile);
        }
    }

    private static void doRemovePreference(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 3) {
            throw new ArgumentValidationException("args are userID itemID");
        }
        if (translatingRecommender == null) {
            long userID = Long.parseLong(CLI.unquote(programArgs[1]));
            long itemID = Long.parseLong(CLI.unquote(programArgs[2]));
            recommender.removePreference(userID, itemID);
        } else {
            String userID = CLI.unquote(programArgs[1]);
            String itemID = CLI.unquote(programArgs[2]);
            translatingRecommender.removePreference(userID, itemID);
        }
    }

    private static void doSetPreference(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 3 && programArgs.length != 4) {
            throw new ArgumentValidationException("args are userID itemID [value]");
        }
        if (translatingRecommender == null) {
            long userID = Long.parseLong(CLI.unquote(programArgs[1]));
            long itemID = Long.parseLong(CLI.unquote(programArgs[2]));
            if (programArgs.length == 3) {
                recommender.setPreference(userID, itemID);
            } else {
                float value = LangUtils.parseFloat(CLI.unquote(programArgs[3]));
                recommender.setPreference(userID, itemID, value);
            }
        } else {
            String userID = CLI.unquote(programArgs[1]);
            String itemID = CLI.unquote(programArgs[2]);
            if (programArgs.length == 3) {
                translatingRecommender.setPreference(userID, itemID);
            } else {
                float value = LangUtils.parseFloat(CLI.unquote(programArgs[3]));
                translatingRecommender.setPreference(userID, itemID, value);
            }
        }
    }

    private static void doSetUserTag(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 3 && programArgs.length != 4) {
            throw new ArgumentValidationException("args are userID tag [value]");
        }
        String userTag = CLI.unquote(programArgs[2]);
        if (translatingRecommender == null) {
            long userID = Long.parseLong(CLI.unquote(programArgs[1]));
            if (programArgs.length == 3) {
                recommender.setUserTag(userID, userTag);
            } else {
                float value = LangUtils.parseFloat(CLI.unquote(programArgs[3]));
                recommender.setUserTag(userID, userTag, value);
            }
        } else {
            String userID = CLI.unquote(programArgs[1]);
            if (programArgs.length == 3) {
                translatingRecommender.setUserTag(userID, userTag);
            } else {
                float value = LangUtils.parseFloat(CLI.unquote(programArgs[3]));
                translatingRecommender.setUserTag(userID, userTag, value);
            }
        }
    }

    private static void doSetItemTag(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 3 && programArgs.length != 4) {
            throw new ArgumentValidationException("args are tag itemID [value]");
        }
        String itemTag = CLI.unquote(programArgs[1]);
        if (translatingRecommender == null) {
            long itemID = Long.parseLong(CLI.unquote(programArgs[2]));
            if (programArgs.length == 3) {
                recommender.setItemTag(itemTag, itemID);
            } else {
                float value = LangUtils.parseFloat(CLI.unquote(programArgs[3]));
                recommender.setItemTag(itemTag, itemID, value);
            }
        } else {
            String itemID = CLI.unquote(programArgs[2]);
            if (programArgs.length == 3) {
                translatingRecommender.setItemTag(itemTag, itemID);
            } else {
                float value = LangUtils.parseFloat(CLI.unquote(programArgs[3]));
                translatingRecommender.setItemTag(itemTag, itemID, value);
            }
        }
    }

    private static String unquote(String s) {
        int length = s.length();
        if (length >= 2 && s.charAt(0) == '\"' && s.charAt(length - 1) == '\"') {
            return s.substring(1, length - 1);
        }
        return s;
    }

    private static void printHelp(String message) {
        System.out.println();
        System.out.println("Myrrix Client command line interface. Copyright Myrrix Ltd, except for included ");
        System.out.println("third-party open source software. Full details of licensing at http://myrrix.com/legal/");
        System.out.println();
        if (message != null) {
            System.out.println(message);
            System.out.println();
        }
    }

    private static MyrrixClientConfiguration buildConfiguration(CLIArgs cliArgs) {
        MyrrixClientConfiguration config = new MyrrixClientConfiguration();
        config.setHost(cliArgs.getHost());
        config.setPort(cliArgs.getPort());
        config.setSecure(cliArgs.isSecure());
        config.setContextPath(cliArgs.getContextPath());
        config.setAllPartitionsSpecification(cliArgs.getAllPartitions());
        config.setUserName(cliArgs.getUserName());
        config.setPassword(cliArgs.getPassword());
        config.setKeystoreFile(cliArgs.getKeystoreFile());
        config.setKeystorePassword(cliArgs.getKeystorePassword());
        return config;
    }

    private static void output(Iterable<RecommendedItem> items) {
        for (RecommendedItem item : items) {
            System.out.println(item.getItemID() + "," + item.getValue());
        }
    }

    private static void outputTranslated(Iterable<TranslatedRecommendedItem> items) {
        for (TranslatedRecommendedItem item : items) {
            System.out.println(item.getItemID() + ',' + item.getValue());
        }
    }

    private static void enableDebugLoggingIn(Class<?> ... classes) {
        for (Class<?> c : classes) {
            java.util.logging.Logger julLogger;
            julLogger.setLevel(Level.FINE);
            for (julLogger = java.util.logging.Logger.getLogger(c.getName()); julLogger != null; julLogger = julLogger.getParent()) {
                for (Handler handler : julLogger.getHandlers()) {
                    handler.setLevel(Level.FINE);
                }
            }
        }
    }
}

