/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.ArgumentPresentingStrategy;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.ConvertTypeOfObject;
import com.lexicalscope.jewel.cli.Option;
import com.lexicalscope.jewel.cli.ValidationErrorBuilder;
import com.lexicalscope.jewel.cli.ValidationErrorBuilderImpl;
import com.lexicalscope.jewel.cli.specification.OptionSpecification;
import com.lexicalscope.jewel.cli.specification.OptionsSpecification;
import com.lexicalscope.jewel.cli.specification.ParsedOptionSpecification;
import com.lexicalscope.jewel.cli.specification.UnparsedOptionSpecification;
import com.lexicalscope.jewel.cli.validation.Argument;
import com.lexicalscope.jewel.cli.validation.OptionCollection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ArgumentPresenterImpl<O> {
    private final OptionsSpecification<O> specification;
    private final ArgumentPresentingStrategy<O> argumentPresentingStrategy;

    public ArgumentPresenterImpl(OptionsSpecification<O> specification, ArgumentPresentingStrategy<O> argumentPresentingStrategy) {
        this.specification = specification;
        this.argumentPresentingStrategy = argumentPresentingStrategy;
    }

    @Option
    public O presentArguments(OptionCollection validatedArguments) throws ArgumentValidationException {
        LinkedHashMap<String, Object> argumentMap = new LinkedHashMap<String, Object>();
        ValidationErrorBuilderImpl validationErrorBuilder = new ValidationErrorBuilderImpl();
        for (ParsedOptionSpecification optionSpecification : this.specification) {
            ConvertTypeOfObject convertTypeOfObject = ConvertTypeOfObject.converterTo((ValidationErrorBuilder)validationErrorBuilder, (OptionSpecification)optionSpecification, optionSpecification.getMethod());
            this.putDefaultInMap(argumentMap, optionSpecification, convertTypeOfObject);
            Argument argument = validatedArguments.getArgument(optionSpecification);
            if (argument == null) continue;
            this.putValuesInMap(argumentMap, optionSpecification, convertTypeOfObject, argument.getValues());
        }
        if (this.specification.hasUnparsedSpecification()) {
            UnparsedOptionSpecification unparsedSpecification = this.specification.getUnparsedSpecification();
            ConvertTypeOfObject convertTypeOfObject = ConvertTypeOfObject.converterTo((ValidationErrorBuilder)validationErrorBuilder, (OptionSpecification)unparsedSpecification, unparsedSpecification.getMethod());
            this.putDefaultInMap(argumentMap, unparsedSpecification, convertTypeOfObject);
            if (!validatedArguments.getUnparsed().isEmpty()) {
                this.putValuesInMap(argumentMap, unparsedSpecification, convertTypeOfObject, validatedArguments.getUnparsed());
            }
        }
        validationErrorBuilder.validate();
        return this.argumentPresentingStrategy.presentArguments(argumentMap);
    }

    private void putValuesInMap(Map<String, Object> argumentMap, OptionSpecification specification, ConvertTypeOfObject<?> convertTypeOfObject, List<String> values) {
        if (specification.isMultiValued()) {
            argumentMap.put(specification.getCanonicalIdentifier(), convertTypeOfObject.convert(values));
        } else if (!values.isEmpty()) {
            argumentMap.put(specification.getCanonicalIdentifier(), convertTypeOfObject.convert(values.get(0)));
        } else if (values.isEmpty()) {
            argumentMap.put(specification.getCanonicalIdentifier(), null);
        }
    }

    private void putDefaultInMap(Map<String, Object> argumentMap, OptionSpecification optionSpecification, ConvertTypeOfObject<?> convertTypeOfObject) {
        if (optionSpecification.isMultiValued() && optionSpecification.hasDefaultValue()) {
            argumentMap.put(optionSpecification.getCanonicalIdentifier(), convertTypeOfObject.convert(optionSpecification.getDefaultValue()));
        } else if (optionSpecification.hasDefaultValue() && optionSpecification.getDefaultValue().size() > 0) {
            argumentMap.put(optionSpecification.getCanonicalIdentifier(), convertTypeOfObject.convert(optionSpecification.getDefaultValue().get(0)));
        }
    }
}

