% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenanova.R
\name{cenanova}
\alias{cenanova}
\title{ANOVA for censored data}
\usage{
cenanova(x1, x2, group, LOG = TRUE, printstat = TRUE)
}
\arguments{
\item{x1}{The column of data values plus detection limits}

\item{x2}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y1} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y1}.}

\item{group}{Grouping or factor variable. Can be either a text or numeric value indicating the group assignment.}

\item{LOG}{Indicator of whether to compute tests in the original units, or on their logarithms.  The default is to use the logarithms (\code{LOG = TRUE}).  To compute in original units, specify the option \code{LOG = FALSE} (or \code{LOG = 0}).}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
Returns the Maximum Likelihood Estimation (MLE) comparison results including Chi-Squared value, degrees of freedom and \code{p-value} of the test. Test assumes log-normal(\code{LOG=TRUE}) or normal(\code{LOG=FALSE}) distribution of residuals from group means.

Tukey's multiple comparison p-values of pairwise differences in group means are also printed.
\itemize{
\item Group Names of groups (NOTE: \verb{== 0} indicates null hypothesis of "equals zero").
\item \code{Estimate} Estimated difference between group means.
\item \verb{Std. Error} Standard error of estimate.
\item \verb{z value} Test statistic.
\item \verb{Pr(>|z|)} P-values for test that difference in means equals zero.
}
}
\description{
Performs a parametric test of differences in means between groups of censored data, followed by a parametric Tukey's multiple comparison test.
}
\details{
Test is computed using Maximum Likelihood Estimation. When a gaussian	distribution model is	used (LOG=FALSE) modeled values may fall below zero, producing unreal p-values (often lower than they should be).  Because of this, testing in log units is preferable and is the default.
}
\references{
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

#' @examples
data(PbHeron)
cenanova(PbHeron$Liver,PbHeron$LiverCen,PbHeron$DosageGroup)

cenanova(PbHeron$Liver,PbHeron$LiverCen,PbHeron$DosageGroup,LOG=FALSE)
}
\seealso{
\link[survival:survreg]{survival::survreg}
}
