% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbr_lm_aov.R
\name{nbr_lm_aov}
\alias{nbr_lm_aov}
\title{Network-based for Linear Model ANOVA}
\usage{
nbr_lm_aov(net, nnodes, idata, mod, diag = FALSE, nperm,
           thrP = 0.05, thrF = NULL, cores = NULL,
           nudist = FALSE, expList = NULL,
           verbose = TRUE, ...)
}
\arguments{
\item{net}{3D volume (2D matrices for each observation) or 2D matrix of edges as columns.}

\item{nnodes}{Integer number of network nodes.}

\item{idata}{Matrix or data.frame with sample inference variables.}

\item{mod}{Character string with independent variables formula.}

\item{diag}{Logical indicating if matrix diagonal is include in the analysis (default: FALSE).}

\item{nperm}{Number of permutations.}

\item{thrP}{Individual edge p-value threshold (if NULL, thrF should be given).}

\item{thrF}{Individual edge F-value threshold (if NULL, thrP should be given).}

\item{cores}{Number of selected cores for parallel computing (default: NULL).}

\item{nudist}{Logical indicating if null distribution stats should be returned (default: FALSE).}

\item{expList}{Character string adding variable names to the varlist of 'clusterExport' (default: NULL).}

\item{verbose}{Logical indicating if messages should be printed (default: TRUE).}

\item{...}{Additional arguments to be passed to the low level 'lm' function.}
}
\value{
List containing the observed statistics and their corresponding FWE p-values,
 if requested by \emph{nudist} it will return the null distribution of permuted values.
 \enumerate{
  \item Observed statistics for every individual edge: corresponding component and strength for each model term.
  \item FWE for components: number size and strength sum, with their corresponding FWE p-value.
  \item Null Distribution: higher component size and strength for each permutation. Only returned if
   \emph{nudist} is TRUE.
}
}
\description{
This function computes the same linear model ANOVA at the network edge level,
 and calculates its family wise error (FWE) cluster of connected edges by permutation.
}
\details{
It's VERY IMPORTANT when giving \emph{net} as a 2D matrix or data.frame, be completely sure that
column distribution fits with that of the upper triangle indices of a \emph{nnodes} * \emph{nnodes} matrix.
This function assumes that.

Regarding the set of \emph{nperm}, I suggest first setting it to small values (5 or 10) in order to test that
everything runs fine. After that, \emph{nperm} equal or higher than 1000 will be necessary in order to
lower the margin of error of the Family-Wise Error p-value.
}
\examples{
data(frontal2D)
\donttest{
ncores <- 2
library(parallel)
if(detectCores() < ncores) ncores <- NULL
nbr_result <- nbr_lm_aov(net = frontal2D[,-(1:3)],
  nnodes = 28, idata = frontal2D[,1:3],
  mod = "~ Group + Sex * Age",
  thrP = 0.01, nperm = 5, cores = ncores)
show(nbr_result)
}

}
