p_mp_mpy <- 
function (data, id.y, nx, steps, bottleneck.y) {
  # pick the idY-th Y
  py <- data[, nx + id.y]

  # User wants percentiles
  if (p_bottleneck_id(bottleneck.y) == 4) {
    mpy <- matrix(quantile(sort(py), seq.int(0, 1, by=1/steps)), ncol=1)
  } else {
    if (p_bottleneck_id(bottleneck.y) %in% c(1, 3)) {
      py.low <- min(py, na.rm=TRUE)
    } else if (p_bottleneck_id(bottleneck.y) == 2) {
      py.low <- 0
    }
    py.high <- max(py, na.rm=TRUE)

    # Select interval
    step    <- (py.high - py.low) / steps

    # define the first column.
    mpy <- matrix(seq.int(py.low, py.high, by=step), ncol=1)
  }

  # Define the bottleneck table
  mp  <- matrix(mpy, nrow=length(mpy), ncol=1)

  # Display Ys as percentage or percentiles
  if (p_bottleneck_id(bottleneck.y) %in% c(1, 2)) {
    mp <- 100 * (mp - py.low) / (py.high - py.low)
  } else if (p_bottleneck_id(bottleneck.y) == 4) {
    mp <- matrix(seq.int(0, 100, by=100/steps), ncol=1)
  }
  
  return( list(mp, mpy) )
}

p_bottleneck_options <- list(
  "percentage.range",
  "percentage.max",
  "actual",
  "percentile"
)

p_validate_bottleneck <-
function (option, x.y) {
  if (is.na(match(option, p_bottleneck_options))) {
    message(paste0("\nBottleneck option '", option, "' for ", x.y,
      " is not valid, using '", p_bottleneck_options[[1]], "'"))
    return(p_bottleneck_options[[1]])
  }
  return(option)
}

p_bottleneck_id <-
function (option_name) {
  if (is.na(match(option_name, p_bottleneck_options))) {
    return(1)
  }
  return(match(option_name, p_bottleneck_options))
}
