% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmNew}
\alias{chmNew}
\title{Create a new NGCHM.}
\usage{
chmNew(
  name,
  ...,
  rowOrder = chmDefaultRowOrder,
  rowDist = "correlation",
  rowAgglom = "ward.D2",
  colOrder = chmDefaultColOrder,
  colDist = "correlation",
  colAgglom = "ward.D2",
  rowAxisType = NULL,
  colAxisType = NULL,
  rowCovariates = NULL,
  colCovariates = NULL,
  format = "original",
  rowGapLocations = NULL,
  rowGapWidth = 5,
  colGapLocations = NULL,
  colGapWidth = 5,
  overview = c(),
  logLevel = "INFO",
  logFile = NULL
)
}
\arguments{
\item{name}{The name under which the NGCHM will be saved to the NGCHM server.}

\item{...}{Zero or more initial objects to include in the NGCHM (see chmAdd).}

\item{rowOrder}{A vector, dendrogram, or function specifying the CHM row order.}

\item{rowDist}{Distance method to use by default RowOrder}

\item{rowAgglom}{Agglomeration method to use by default RowOrder}

\item{colOrder}{A vector, dendrogram, or function specifying the CHM column order.}

\item{colDist}{Distance method to use by default ColOrder}

\item{colAgglom}{Agglomeration method to use by default ColOrder}

\item{rowAxisType}{The type(s) of the row labels (default: None).}

\item{colAxisType}{The type(s) of the column labels (default: None).}

\item{rowCovariates}{Covariate(Bar)(s) to add to the rows (default: None).}

\item{colCovariates}{Covariate(Bar)(s) to add to the columns (default: None).}

\item{format}{The format of NGCHM to produce (default: 'original').}

\item{rowGapLocations}{Locations for row gaps. Specify as a list of integers or \code{\link[=chmTreeGaps]{chmTreeGaps()}} function.}

\item{rowGapWidth}{Width of row gaps (default: 5 rows)}

\item{colGapLocations}{Locations for col gaps. Specify as a list of integers or \code{\link[=chmTreeGaps]{chmTreeGaps()}} function.}

\item{colGapWidth}{Width of col gaps (default: 5 cols)}

\item{overview}{The format(s) of overview image(s) to create (default: None).}

\item{logLevel}{The level of logs to output}

\item{logFile}{The file to which logs should be output}
}
\value{
An object of class ngchm
}
\description{
This function creates a Next Generation Clustered Heat Map (NGCHM) object in memory.
Additional parameters will be added to the new NGCHM (see chmAdd).
The bare NGCHM needs at least one data layer added to it before it can be compiled.
This function requires \strong{git} to be installed.
}
\examples{
mychm <- chmNew("test_chm")
mychm <- chmNew("test_chm", rowGapLocations = c(3, 5))
mychm <- chmNew("test_chm", rowGapLocations = chmTreeGaps(4))
mychm <- chmNew("test_chm", rowGapWidth = 3)

}
\seealso{
\linkS4class{ngchm}

\linkS4class{ngchmServer}

\code{\link[=chmAdd]{chmAdd()}}

\code{\link[=chmAddAxisType]{chmAddAxisType()}}

\code{\link[=chmAddCovariateBar]{chmAddCovariateBar()}}

\code{\link[=chmAddProperty]{chmAddProperty()}}

\code{\link[=chmAddOverview]{chmAddOverview()}}

\code{\link[=chmInstall]{chmInstall()}}

\code{\link[=chmExportToFile]{chmExportToFile()}}

\code{\link[=chmExportToPDF]{chmExportToPDF()}}

\code{\link[=chmExportToHTML]{chmExportToHTML()}}
}
