#' util_calc_boundaries
#'
#' @description Determine upper class boundaries for classification of a matrix with values ranging 0-1 based upon an
#' vector of cumulative proportions.
#'
#' @param x [\code{matrix(x,y)}]\cr 2D matrix of data values.
#' @param cumulative_proportions [\code{numerical}]\cr Vector of class cumulative proportions, as generated by \code{w2cp}.
#'
#'
#' @return Numerical vector with boundaries for matrix classification
#'
#'
#' @examples
#' x <- matrix(runif(100,0,1),10,10)
#' y <- util_w2cp(c(0.5, 0.25, 0.25)) #cumulative proportion
#' util_calc_boundaries(x,y)
#'
#' @keywords internal
#' @export


util_calc_boundaries <- function(x, cumulative_proportions) {

  # Check function arguments ----
  checkmate::assert_matrix(x, min.rows = 1, min.cols = 1)
  checkmate::assert_numeric(cumulative_proportions)
  # checkmate::assert_true(utils::tail(cumulative_proportions, n = 1) == 1) #ensures cumulative proportion structure

  # Get number of cells  ----
  n_cells <- length(x)

  # Use number of cells to find index of upper boundary element ----
  boundary_indexes <- as.integer( (cumulative_proportions * n_cells))

  # Get boundary values ----
  boundary_values <- sort(as.vector(x))[boundary_indexes]

  return(boundary_values)

}
