% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_classify.R
\name{util_classify}
\alias{util_classify}
\title{util_classify}
\usage{
util_classify(x, weighting, level_names = NULL)
}
\arguments{
\item{x}{[\code{matrix(x,y)}]\cr
2D matrix of data values.}

\item{weighting}{[\code{numerical}]\cr
Vector of numeric values.}

\item{level_names}{[\code{character}]\cr
Vector of names for the factor levels.}
}
\value{
RasterLayer
}
\description{
Classify a raster into proportions based upon a vector of class
weightings.
}
\details{
The number of elements in the weighting vector determines the number of classes
in the resulting matrix. The classes start with the value 1.
If non-numerical levels are required, the user can specify a vector to turn the
numerical factors into other data types, for example into character strings (i.e. class labels).
If the numerical vector of weightings does not sum up to 1, the sum of the
weightings is divided by the number of elements in the weightings vector and this is then used for the classification.
}
\examples{
x <- nlm_random(10, 10)
y <- c(0.5, 0.25, 0.25)
util_classify(x, y, level_names = c("Land Use 1", "Land Use 2", "Land Use 3"))


}
