% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_scaling.R
\name{prepare_nmar_scaling}
\alias{prepare_nmar_scaling}
\title{Prepare scaled matrices and moments (low-level)}
\usage{
prepare_nmar_scaling(
  Z_un,
  X_un,
  mu_x_un,
  standardize,
  weights = NULL,
  weight_mask = NULL
)
}
\arguments{
\item{Z_un}{response model matrix (with intercept column).}

\item{X_un}{auxiliary model matrix (no intercept), or NULL.}

\item{mu_x_un}{named numeric vector of auxiliary means on the original scale
(names must match \code{colnames(X_un)}), or \code{NULL}.}

\item{standardize}{logical; apply standardization if TRUE.}

\item{weights}{Optional numeric vector used for weighted scaling.}

\item{weight_mask}{Optional logical mask or nonnegative numeric multipliers
applied to \code{weights}.}
}
\value{
A list with components \code{Z}, \code{X}, \code{mu_x}, and
  \code{recipe}.
}
\description{
Prepare scaled matrices and moments (low-level)
}
\keyword{internal}
