% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subroutine.R
\name{subroutine}
\alias{subroutine}
\title{Subroutine}
\usage{
subroutine(m, advan = NA, trans = 1, recursive = TRUE)
}
\arguments{
\item{m}{An nm object.}

\item{advan}{Character. desired ADVAN.}

\item{trans}{Character. desired TRANS.}

\item{recursive}{Logical (default = TRUE). Internal argument, do not modify.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Makes the necessary code changes to go from one \code{ADVAN} (and \code{TRANS}) to
another.
}
\details{
Can only switch between subroutines listed in \code{available_advans}.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1",
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))


advan(m1) ## 2
trans(m1) ## 1

m1 <- m1 \%>\% subroutine(advan = 2, trans = 2)

ds <- .available_advans \%>\%
  dplyr::filter(oral) \%>\%
  dplyr::mutate(
    m = m1 \%>\% child(run_id = label) \%>\%
      subroutine(advan = advan, trans = trans)
  )

ds

ds$m \%>\% dollar("PK")

}
\seealso{
\code{\link[=advan]{advan()}}
}
