% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmpool.R
\name{km.pool}
\alias{km.pool}
\title{Perform Kaplan-Meier estmation over the multiply imputed survival data sets}
\usage{
km.pool(obj, time, status)
}
\arguments{
\item{obj}{A 'nnmi' object, that contains imputed data for the missing covariate and the censored observations.}

\item{time}{A vector contains the observed time.}

\item{status}{A vector contains the event indicator.}
}
\value{
A data frame contains pooled Kaplan-Meier estimates.
}
\description{
This function estimates Kaplan-Meier estimates based on Rubin's rules (multiple imputation algorithms) (Rubin, 2004).
}
\examples{

# load required packages
library(NNMIS)
library(survival)

# load data set - stanford2 in package 'survival'
data("stanford2")
head(stanford2)
attach(stanford2)

# performance multiple imputation on missing covariate t5 and
# censored observations based on the imputed missing covariates
imp.dat <- NNMIS(t5, xa=age, xb=age, time=time, event=status, imputeCT=TRUE, Seed = 1234)

# check imputation results
head(imp.dat$dat.T.NNMI)

# combine inference from imputed data sets using Rubin's rules
# Kaplan-Meier estimates
kmfit <- km.pool(imp.dat, time, status)
plotKM(kmfit)

}
\references{
Rubin DB. Multiple imputation for nonresponse in surveys. New York: John Wiley and Sons; 2004.
}
