% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dependence.R
\name{VN.dep}
\alias{VN.dep}
\title{VN Dependence}
\usage{
VN.dep(x, y, order = ceiling(log10(length(x))), degree = ifelse(length(x) <
  100, 0, 1))
}
\arguments{
\item{x}{Variable 1}

\item{y}{Variable 2}

\item{order}{Number of partial moment quadrants to be generated}

\item{degree}{Defaults to 0 for smaller number of observations}
}
\description{
Returns the dependence between two variables based on higher order partial moment correlations measured by frequency or area.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
\dontrun{VN.dep(x,y)}
}
\keyword{dependence}

