% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dy_dx.R
\name{dy.dx}
\alias{dy.dx}
\title{Partial Derivative dy/dx}
\usage{
dy.dx(x, y, order = NULL, local.point = median(x))
}
\arguments{
\item{x}{Independent Variable}

\item{y}{Dependent Variable}

\item{order}{Controls the number of partial moment quadrant means.  Defaults to NULL to allow \link{VN.reg} to determine optimal order based on R2 of regression.  \code{order='max'} generates a more accurate derivative for well specified cases.}

\item{local.point}{Independent variable point to be evaluated.  Defaults to \code{median(x)}.}
}
\description{
Returns the numerical partial derivate of y wrt x for a point of interest.
}
\examples{
x<-seq(0,2*pi,pi/100); y<-sin(x)
dy.dx(x,y,local.point=1.75)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{derivative,}
\keyword{nonlinear}
\keyword{partial}
\keyword{regression}

