% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{NNS.reg}
\alias{NNS.reg}
\title{NNS Regression}
\usage{
NNS.reg(x, y, order = NULL, s.t.n = 0.99, type = NULL, point.est = NULL,
  location = "top", return.values = TRUE, plot = TRUE,
  plot.regions = FALSE, residual.plot = TRUE, threshold = 0,
  dep.order = NULL, n.best = 2, noise.reduction = "mean", norm = NULL,
  dist = "L2", multivariate.call = FALSE)
}
\arguments{
\item{x}{a vector, matrix or data frame of variables of numeric or factor data types.}

\item{y}{a numeric or factor vector with compatible dimsensions to \code{x}.}

\item{order}{integer; Controls the number of partial moment quadrant means.  Users are encouraged to try different \code{(order=...)} integer settings with \code{(noise.reduction="off")}.  \code{(order="max")} will force a limit condition perfect fit.}

\item{s.t.n}{numeric [0,1]; Signal to noise parameter, sets the threshold of \code{(NNS.dep)} which reduces \code{("order")} when \code{(order=NULL)}.  Defaults to 0.99 to ensure high dependence for higher \code{("order")} and endpoint determination.  \code{(noise.reduction="off")} sets \code{(s.t.n=0)} to allow for maximum fit.}

\item{type}{\code{NULL} (default).  To perform logistic regression, set to \code{(type = "LOGIT")}.  To perform a classification, set to \code{(type = "CLASS")}.}

\item{point.est}{a numeric or factor vector with compatible dimsensions to \code{x}.  Returns the fitted value \code{y.hat} for any value of \code{x}.}

\item{location}{Sets the legend location within the plot, per the \code{x} and \code{y} co-ordinates used in base graphics \link{legend}.}

\item{return.values}{logical; \code{TRUE} (default), set to \code{FALSE} in order to only display a regression plot and call values as needed.}

\item{plot}{logical; \code{TRUE} (default) To plot regression.}

\item{plot.regions}{logical; \code{FALSE} (default).  Generates 3d regions associated with each regression point for multivariate regressions.  Note, adds significant time to routine.}

\item{residual.plot}{logical; \code{TRUE} (default) To plot the \code{y.hat} and \code{Y}.}

\item{threshold}{numeric [0,1]; \code{threshold=0} (default) Sets the correlation threshold for independent variables.}

\item{dep.order}{\code{NULL} (defualt) integer; Sets the internal \code{order} for \link{NNS.dep}.  Categorical variables typically require \code{dep.order=1}.  Error message will alert user if this is the case.}

\item{n.best}{integer; \code{n.best=2} (default) Sets the number of nearest regression points to use in weighting for multivariate regression.  \code{n.best="all"} will select and weight all generated regression points.}

\item{noise.reduction}{the method of determing regression points options: ("mean","median","mode","off"); In low signal:noise situations,\code{(noise.reduction="mean")}  uses means for \link{NNS.dep} restricted partitions, \code{(noise.reduction="median")}  uses medians instead of means for \link{NNS.dep} restricted partitions, while \code{(noise.reduction="mode")}  uses modes instead of means for \link{NNS.dep} restricted partitions.  \code{(noise.reduction="off")}  allows for maximum possible fit with a specific \code{order}.}

\item{norm}{\code{NULL} (default) the method of normalization options: ("NNS","std"); Normalizes \code{x} between 0 and 1 for multivariate regression when set to \code{(norm="std")}, or normalizes \code{x} according to \link{NNS.norm} when set to \code{(norm="NNS")}.}

\item{dist}{the method of distance calculation; Selects the distance calculation used. \code{dist="L2"} (default) selects the Euclidean distance and \code{dist="L1"} seclects the Manhattan distance.}

\item{multivariate.call}{Internal parameter for multivariate regressions.}
}
\value{
UNIVARIATE regression returns the values:  \code{"Fitted"} for only the fitted values, \code{y.hat}; \code{"Fitted.xy"} for a data frame of \code{x},\code{y} and \code{y.hat}; \code{"derivative"} for the coefficient of the \code{x} and its applicable range;  \code{"partition"} returns the \code{x},\code{y}, \code{"NNS.ID"} assigned to the observation and \code{y.hat}; \code{"Point"} returns the \code{x} point(s) being evaluated; \code{"Point.est"} for the predicted value generated; \code{"Point"} returns the \code{x} point(s) being evaluated; \code{"regression.points"} provides the points used in the regression equation for the given order of partitions; \code{"R2"} provides the goodness of fit; \code{"MSE"} returns the MSE between \code{y} and \code{y.hat}; \code{"Prediction.Accuracy"} returns the correct rounded \code{"Point.est"} used in classifications versus the categorical \code{y}.

MULTIVARIATE regression returns the values: \code{"Fitted"} for only the fitted values of \code{x}; \code{"Fitted.xy"} for a data frame of \code{y} and fitted values; \code{"RPM"} provides the Regression Point Matrix, the points for each \code{x} used in the regression equation for the given order of partitions; \code{"rhs.partitions"} returns the partition points for each \code{x}; \code{"partition"} returns the \code{x},\code{y}, \code{"NNS.ID"} assigned to the observation and \code{y.hat}; \code{"Point"} returns the \code{x} point(s) being evaluated; \code{"Point.est"} returns the predicted value generated; \code{"equation"} returns the synthetic X* dimension reduction equation.
}
\description{
Generates a nonlinear regression based on partial moment quadrant means.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
NNS.reg(x,y)

## Manual {order} selection
NNS.reg(x,y,order=2)

## Maximum {order} selection
NNS.reg(x,y,order='max')

## x-only paritioning (Univariate only)
NNS.reg(x,y,type="XONLY")

## Logistic Regression (Univariate only)
NNS.reg(x,y,type="LOGIT")

## For Multiple Regression:
x<-cbind(rnorm(100),rnorm(100),rnorm(100)); y<-rnorm(100)
NNS.reg(x,y,point.est=c(.25,.5,.75))

## For Multiple Regression based on Synthetic X* (Dimension Reduction):
x<-cbind(rnorm(100),rnorm(100),rnorm(100)); y<-rnorm(100)
NNS.reg(x,y,point.est=c(.25,.5,.75),type="CLASS")

## IRIS dataset example:
#Dimension Reduction:
NNS.reg(iris[,1:4],iris[,5],type="CLASS",order=5)
#Multiple Regression:
NNS.reg(iris[,1:4],iris[,5],order=2,noise.reduction='off')

## To call fitted values:
x<-rnorm(100); y<-rnorm(100)
NNS.reg(x,y)$Fitted

## To call partial derivative (univariate regression only):
x<-rnorm(100); y<-rnorm(100)
NNS.reg(x,y)$derivative

}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{classifier}
\keyword{nonlinear}
\keyword{regression,}

