% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPM_UPM_VaR.R
\name{LPM.VaR}
\alias{LPM.VaR}
\title{LPM VaR}
\usage{
LPM.VaR(percentile, degree, x, extend = NULL)
}
\arguments{
\item{percentile}{numeric [0,1]; The percentile for left-tail VaR.}

\item{degree}{integer; \code{(degree=0)} for discrete distributions, \code{(degree=1)} for continuous distributions.}

\item{x}{a numeric vector.}

\item{extend}{options: ("yes", NULL); \code{NULL} (default) Sets the \code{"extendInt"} argument from \link{uniroot}.}
}
\value{
Returns a numeric value representing the point at which \code{"percentile"} of the area of \code{x} is above.
}
\description{
Generates a VaR based on the Lower Partial Moment ratio
}
\note{
If endpoint error is generated, set \code{(extend="yes")}.
}
\examples{
set.seed(123)
x<-rnorm(100)
## For 95th percentile VaR (left-tail)
LPM.VaR(0.95,0,x)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{VaR}
