% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Numerical_Differentiation.R
\name{NNS.diff}
\alias{NNS.diff}
\title{NNS Numerical Differentiation}
\usage{
NNS.diff(f, point, h = 0.1, tol = 1e-10, print.trace = FALSE)
}
\arguments{
\item{f}{an expression or call or a formula with no lhs.}

\item{point}{numeric; Point to be evaluated for derivative of a given function \code{f}.}

\item{h}{numeric [0, ...]; Initial step for secant projection.  Defaults to \code{(h = 0.1)}.}

\item{tol}{numeric; Sets the tolerance for the stopping condition of the inferred \code{h}.  Defualts to \code{(tol = 1e-10)}.}

\item{print.trace}{logical; \code{FALSE} (default) Displays each iteration, lower y-intercept, upper y-intercept and inferred \code{h}.}
}
\value{
Returns a matrix of values, intercepts, derivatives, inferred step sizes for multiple methods of estimation.
}
\description{
Determines numerical derivative of a given function using projected secant lines on the y-axis.  These projected points infer finite steps \code{h}, in the finite step method.
}
\examples{
f <- function(x) sin(x) / x
NNS.diff(f, 4.1)

g <- function(x) sin(x)
NNS.diff(g, 1)

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{differentiation,}
\keyword{numerical}
\keyword{secant}
